"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CupomController = void 0;
const common_2 = require("@nestjs/common");
const cupom_service_1 = require("./cupom.service");
const create_cupom_dto_1 = require("./dto/create-cupom.dto");
const update_cupom_dto_1 = require("./dto/update-cupom.dto");
let CupomController = class CupomController {
    cupomService;
    constructor(cupomService) {
        this.cupomService = cupomService;
    }
    create(createCupomDto) {
        return this.cupomService.create(createCupomDto);
    }
    descont(createCupomDto, orderId) {
        return this.cupomService.descont(orderId, createCupomDto.codigo);
    }
    removeDescont(orderId) {
        return this.cupomService.removeDescont(orderId);
    }
    findAll() {
        return this.cupomService.findAll();
    }
    findOne(id) {
        return this.cupomService.findOne(+id);
    }
    update(id, updateCupomDto) {
        return this.cupomService.update(+id, updateCupomDto);
    }
    remove(id) {
        return this.cupomService.remove(+id);
    }
};
exports.CupomController = CupomController;
__decorate([
    (0, common_2.Post)(),
    __param(0, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_cupom_dto_1.CreateCupomDto]),
    __metadata("design:returntype", void 0)
], CupomController.prototype, "create", null);
__decorate([
    (0, common_2.Post)('/desconto/:orderId'),
    __param(0, (0, common_2.Body)()),
    __param(1, (0, common_2.Param)('orderId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_cupom_dto_1.CreateCupomDto, Number]),
    __metadata("design:returntype", void 0)
], CupomController.prototype, "descont", null);
__decorate([
    (0, common_2.Post)('/removeDesconto/:orderId'),
    __param(0, (0, common_2.Param)('orderId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], CupomController.prototype, "removeDescont", null);
__decorate([
    (0, common_2.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], CupomController.prototype, "findAll", null);
__decorate([
    (0, common_2.Get)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], CupomController.prototype, "findOne", null);
__decorate([
    (0, common_2.Patch)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_cupom_dto_1.UpdateCupomDto]),
    __metadata("design:returntype", void 0)
], CupomController.prototype, "update", null);
__decorate([
    (0, common_2.Delete)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], CupomController.prototype, "remove", null);
exports.CupomController = CupomController = __decorate([
    (0, common_2.Controller)('cupom'),
    __metadata("design:paramtypes", [cupom_service_1.CupomService])
], CupomController);
//# sourceMappingURL=cupom.controller.js.map