"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CupomService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const cupom_entity_1 = require("./entities/cupom.entity");
const order_entity_1 = require("../orders/entities/order.entity");
const order_product_entity_1 = require("../orders/entities/order_product.entity");
let CupomService = class CupomService {
    cupomRepository;
    orderRepository;
    orderProductRepository;
    constructor(cupomRepository, orderRepository, orderProductRepository) {
        this.cupomRepository = cupomRepository;
        this.orderRepository = orderRepository;
        this.orderProductRepository = orderProductRepository;
    }
    async create(createCupomDto) {
        const exist = await this.cupomRepository.findOne({
            where: {
                codigo: createCupomDto.codigo
            }
        });
        if (exist) {
            throw new common_2.BadRequestException('Um cupom com este código já existe.');
        }
        else {
            const cupom = this.cupomRepository.create(createCupomDto);
            await this.cupomRepository.save(cupom);
            return cupom;
        }
    }
    async descont(orderId, codigo) {
        const order = await this.orderRepository.findOne({
            where: { id: orderId },
        });
        if (!order) {
            throw new common_2.NotFoundException('Pedido não encontrado.');
        }
        const cupom = await this.cupomRepository.findOne({
            where: { codigo: codigo }
        });
        if (!cupom) {
            throw new common_2.NotFoundException('Cupom inválido ou não encontrado.');
        }
        if (order.descont) {
            throw new common_2.BadRequestException('Um cupom já foi aplicado a este pedido. Remova o cupom existente antes de aplicar um novo.');
        }
        order.cupom = cupom;
        order.descont = true;
        await this.orderRepository.save(order);
        return order;
    }
    async removeDescont(orderId) {
        const order = await this.orderRepository.findOne({
            where: { id: orderId },
        });
        if (!order) {
            throw new common_2.NotFoundException('Pedido não encontrado.');
        }
        if (!order.descont) {
            throw new common_2.BadRequestException('Nenhum desconto foi aplicado a este pedido.');
        }
        order.cupom = null;
        order.descont = false;
        await this.orderRepository.save(order);
        return order;
    }
    findAll() {
        return this.cupomRepository.find();
    }
    findOne(id) {
        return `This action returns a #${id} cupom`;
    }
    update(id, updateCupomDto) {
        return this.cupomRepository.update(id, updateCupomDto);
    }
    remove(id) {
        return this.cupomRepository.delete(id);
    }
};
exports.CupomService = CupomService;
exports.CupomService = CupomService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(cupom_entity_1.Cupom)),
    __param(1, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __param(2, (0, typeorm_1.InjectRepository)(order_product_entity_1.OrderProduct)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], CupomService);
//# sourceMappingURL=cupom.service.js.map