import { Repository } from 'typeorm';
import { Order } from 'src/ecommerce/orders/entities/order.entity';
import { Status } from 'src/shared/enums/enum';
import { User } from 'src/shared/users/entities/user.entity';
export declare class ReportsService {
    private readonly orderRepository;
    private readonly userRepository;
    constructor(orderRepository: Repository<Order>, userRepository: Repository<User>);
    getOrdersPerHour(date: string): Promise<{
        hour: string;
        total: number;
    }[]>;
    findAllClients(): Promise<User[]>;
    getCardsInfo(): Promise<{
        totalOrders: number;
        totalAmount: number;
        averageTicket: number;
    }>;
    countTotalAmount(): Promise<{
        totalOrders: any;
        totalAmount: any;
    }>;
    getDetailsByOrderId(orderId: number): Promise<{
        id: number;
        status: Status;
        total_items: number;
        total_amount: number;
        created_at: Date;
        updated_at: Date;
        payment_method: import("src/shared/enums/enum").PaymentMethod;
        paymentId: string;
        order_product: {
            id: number;
            quantity: number;
            unit_price: number;
            product: {
                id: number;
                cod_factory: string;
                name: string;
                description: string;
                image: string;
                line: string;
                category: string;
            };
        }[];
    }[]>;
    getFinishedOrders(): Promise<{
        id: number;
        status: Status;
        total_items: number;
        total_amount: number;
        created_at: Date;
        updated_at: Date;
        payment_method: import("src/shared/enums/enum").PaymentMethod;
        paymentId: string;
        order_product: {
            id: number;
            quantity: number;
            unit_price: number;
            product: {
                id: number;
                cod_factory: string;
                name: string;
                description: string;
                image: string;
                line: string;
                category: string;
            };
        }[];
    }[]>;
    getTopProductsPerDay(): Promise<{
        id: any;
        name: any;
        image: any;
        price: number;
        totalQuantitySold: number;
    }[]>;
    countTotalOrders(): Promise<any>;
    percentComplete(): Promise<number>;
    countTotalAmountOrders(): Promise<any>;
}
