import { ReportsService } from '../../application/services/reports.service';
export declare class ReportsController {
    private readonly reportsService;
    constructor(reportsService: ReportsService);
    getOrdersPerHour(date: string): Promise<{
        hour: string;
        total: number;
    }[]>;
    findAllClientsByStoreId(): Promise<import("../../../../shared/users/entities/user.entity").User[]>;
    getCardsInfo(): Promise<{
        totalOrders: number;
        totalAmount: number;
        averageTicket: number;
    }>;
    countTotalAmount(): Promise<{
        totalOrders: any;
        totalAmount: any;
    }>;
    getDetailsByOrderId(orderId: string, currentUserId: number): Promise<{
        id: number;
        status: import("src/shared/enums/enum").Status;
        total_items: number;
        total_amount: number;
        created_at: Date;
        updated_at: Date;
        payment_method: import("src/shared/enums/enum").PaymentMethod;
        paymentId: string;
        order_product: {
            id: number;
            quantity: number;
            unit_price: number;
            product: {
                id: number;
                cod_factory: string;
                name: string;
                description: string;
                image: string;
                line: string;
                category: string;
            };
        }[];
    }[]>;
    getFinishedOrders(): Promise<{
        id: number;
        status: import("src/shared/enums/enum").Status;
        total_items: number;
        total_amount: number;
        created_at: Date;
        updated_at: Date;
        payment_method: import("src/shared/enums/enum").PaymentMethod;
        paymentId: string;
        order_product: {
            id: number;
            quantity: number;
            unit_price: number;
            product: {
                id: number;
                cod_factory: string;
                name: string;
                description: string;
                image: string;
                line: string;
                category: string;
            };
        }[];
    }[]>;
    getTopProductsPerDay(): Promise<{
        id: any;
        name: any;
        image: any;
        price: number;
        totalQuantitySold: number;
    }[]>;
}
