"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReportsController = void 0;
const common_2 = require("@nestjs/common");
const reports_service_1 = require("../../application/services/reports.service");
const role_guard_1 = require("../../../../shared/auth/role/role.guard");
const auth_guard_1 = require("../../../../shared/auth/auth.guard");
const required_roles_decorator_1 = require("../../../../shared/auth/required-roles.decorator");
const enum_1 = require("../../../../shared/enums/enum");
const current_user_decorator_1 = require("../../../../shared/users/current.user.decorator");
let ReportsController = class ReportsController {
    reportsService;
    constructor(reportsService) {
        this.reportsService = reportsService;
    }
    getOrdersPerHour(date) {
        return this.reportsService.getOrdersPerHour(date);
    }
    findAllClientsByStoreId() {
        return this.reportsService.findAllClients();
    }
    getCardsInfo() {
        return this.reportsService.getCardsInfo();
    }
    countTotalAmount() {
        return this.reportsService.countTotalAmount();
    }
    getDetailsByOrderId(orderId, currentUserId) {
        return this.reportsService.getDetailsByOrderId(+orderId);
    }
    getFinishedOrders() {
        return this.reportsService.getFinishedOrders();
    }
    getTopProductsPerDay() {
        return this.reportsService.getTopProductsPerDay();
    }
};
exports.ReportsController = ReportsController;
__decorate([
    (0, common_2.Get)('/pedidos-por-hora'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE, enum_1.Roles.ADMFINANCIAL),
    __param(0, (0, common_2.Query)('intervalo')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ReportsController.prototype, "getOrdersPerHour", null);
__decorate([
    (0, common_2.Get)('clientes'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE, enum_1.Roles.ADMFINANCIAL),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ReportsController.prototype, "findAllClientsByStoreId", null);
__decorate([
    (0, common_2.Get)('cards'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE, enum_1.Roles.ADMFINANCIAL),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ReportsController.prototype, "getCardsInfo", null);
__decorate([
    (0, common_2.Get)('total-da-loja'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE, enum_1.Roles.ADMFINANCIAL),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ReportsController.prototype, "countTotalAmount", null);
__decorate([
    (0, common_2.Get)(':orderId/pedido'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE, enum_1.Roles.ADMFINANCIAL),
    __param(0, (0, common_2.Param)('orderId')),
    __param(1, (0, current_user_decorator_1.CurrentUser)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], ReportsController.prototype, "getDetailsByOrderId", null);
__decorate([
    (0, common_2.Get)('/pedidos-finalizados'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE, enum_1.Roles.ADMFINANCIAL),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ReportsController.prototype, "getFinishedOrders", null);
__decorate([
    (0, common_2.Get)('/top-produtos'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE, enum_1.Roles.ADMFINANCIAL),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ReportsController.prototype, "getTopProductsPerDay", null);
exports.ReportsController = ReportsController = __decorate([
    (0, common_2.Controller)('relatorios'),
    __metadata("design:paramtypes", [reports_service_1.ReportsService])
], ReportsController);
//# sourceMappingURL=reports.controller.js.map