"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateUserResponseDto = exports.CreateUserDto = void 0;
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const enum_1 = require("../../enums/enum");
class CreateUserDto {
    document;
    company_name;
    user_name;
    cellphone;
    email;
    password;
    roles;
}
exports.CreateUserDto = CreateUserDto;
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'O campo CNPJ da Empresa é obrigatório' }),
    (0, class_validator_1.Length)(9, 14, { message: 'O campo de CNPJ deve conter 14 digitos' }),
    __metadata("design:type", String)
], CreateUserDto.prototype, "document", void 0);
__decorate([
    (0, class_transformer_1.Transform)(({ value }) => value.toLowerCase()),
    (0, class_validator_1.IsString)({ message: 'O nome da empresa deve ser uma string.' }),
    (0, class_validator_1.MinLength)(3, {
        message: 'O nome da empresa deve ter no mínimo 3 caracteres.',
    }),
    (0, class_validator_1.IsNotEmpty)({ message: 'O campo nome da empresa é obrigatório' }),
    __metadata("design:type", String)
], CreateUserDto.prototype, "company_name", void 0);
__decorate([
    (0, class_transformer_1.Transform)(({ value }) => value.toLowerCase()),
    (0, class_validator_1.IsString)({ message: 'O nome deve ser uma string.' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'O nome não pode estar vazio.' }),
    (0, class_validator_1.MinLength)(3, { message: 'O nome deve ter no mínimo 3 caracteres.' }),
    __metadata("design:type", String)
], CreateUserDto.prototype, "user_name", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'O campo telefone não pode ser vázio' }),
    (0, class_validator_1.Length)(11, 11, { message: 'O campo telefone deve 11 digitos' }),
    __metadata("design:type", String)
], CreateUserDto.prototype, "cellphone", void 0);
__decorate([
    (0, class_transformer_1.Transform)(({ value }) => value.toLowerCase()),
    (0, class_validator_1.IsEmail)({}, { message: 'Por favor, forneça um endereço de e-mail válido.' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'O e-mail não pode estar vazio.' }),
    __metadata("design:type", String)
], CreateUserDto.prototype, "email", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'O campo senha é obrigatório' }),
    (0, class_validator_1.IsStrongPassword)({ minLength: 6, minLowercase: 0, minUppercase: 0, minSymbols: 0 }, { message: 'A senha deve conter pelo menos 6 caracteres' }),
    __metadata("design:type", String)
], CreateUserDto.prototype, "password", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(enum_1.Roles),
    __metadata("design:type", String)
], CreateUserDto.prototype, "roles", void 0);
class CreateUserResponseDto {
    'access_token';
}
exports.CreateUserResponseDto = CreateUserResponseDto;
//# sourceMappingURL=create-user.dto.js.map