"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const bcrypt = require("bcrypt");
const user_entity_1 = require("./entities/user.entity");
const equipament_entity_1 = require("../../visoflex360/equipaments/entities/equipament.entity");
const door_entity_1 = require("../../visoflex360/doors/entities/door.entity");
const auth_service_1 = require("../auth/auth.service");
const password_reset_token_entity_1 = require("./entities/password-reset-token.entity");
const event_emitter_1 = require("@nestjs/event-emitter");
let UsersService = class UsersService {
    usersRepository;
    resetTokenRepository;
    equipamentsRepository;
    doorsRepository;
    authService;
    eventEmitter;
    constructor(usersRepository, resetTokenRepository, equipamentsRepository, doorsRepository, authService, eventEmitter) {
        this.usersRepository = usersRepository;
        this.resetTokenRepository = resetTokenRepository;
        this.equipamentsRepository = equipamentsRepository;
        this.doorsRepository = doorsRepository;
        this.authService = authService;
        this.eventEmitter = eventEmitter;
    }
    async create(createUserDto) {
        const userExist = await this.findOneByEmail(createUserDto.email);
        if (userExist) {
            return { message: ['E-mail já cadastrado'] };
        }
        let sincCode = '#' + Math.floor(10000 + Math.random() * 90000);
        while ((await this.usersRepository.findOneBy({ sinc_code: sincCode })) !== null) {
            sincCode = '#' + Math.floor(10000 + Math.random() * 90000);
        }
        const password = await bcrypt.hash(createUserDto.password, 10);
        const user = await this.usersRepository.create({
            ...createUserDto,
            password,
            sinc_code: sincCode,
        });
        const userCreated = await this.usersRepository.save(user);
        if (!userCreated) {
            throw new common_2.BadRequestException('Erro durante a criação da conta');
        }
        return this.authService.login(userCreated);
    }
    async forgotPassword(email) {
        const user = await this.usersRepository.findOneBy({ email });
        if (!user) {
            return {
                message: 'Se o e-mail estiver cadastrado, um código de recuperação será enviado.',
            };
        }
        await this.resetTokenRepository.update({ user: { id: user.id } }, { used: true });
        const code = Math.floor(100000 + Math.random() * 900000).toString();
        const expires_at = new Date();
        expires_at.setMinutes(expires_at.getMinutes() + 15);
        const resetToken = this.resetTokenRepository.create({
            user: user,
            code,
            expires_at,
        });
        await this.resetTokenRepository.save(resetToken);
        this.eventEmitter.emit('forgot.password', {
            cellphone: user.cellphone,
            code,
        });
        return {
            message: 'Se o e-mail estiver cadastrado, um código de recuperação será enviado.',
        };
    }
    async findMyProfile(id) {
        const user = await this.findOne(id);
        if (!user) {
            throw new common_2.NotFoundException('Usuário não encontrado');
        }
        return {
            id: user.id,
            document: user.document,
            company_name: user.company_name,
            user_name: user.user_name,
            email: user.email,
            roles: user.roles,
            cellphone: user.cellphone,
            maintanance_notf: user.maintanance_notf,
            alert_notf: user.alert_notf,
            sinc_code: user.sinc_code,
        };
    }
    findOne(id) {
        return this.usersRepository.findOneBy({ id });
    }
    findOneByEmail(email) {
        return this.usersRepository.findOneBy({ email });
    }
    async findResume() {
        const users = await this.usersRepository.find();
        const hasEquipament = await Promise.all(users.map(async (user) => {
            const equipaments = await this.equipamentsRepository.find({
                where: { user: { id: user.id } },
            });
            const hasAlert = await this.doorsRepository.count({
                where: {
                    has_alert: true,
                    equipament: {
                        user: {
                            id: user.id,
                        },
                    },
                },
                relations: {
                    equipament: {
                        user: true,
                    },
                },
            });
            return {
                id: user.id,
                nome_empresa: user.company_name,
                documento: user.document,
                nome_cliente: user.user_name,
                sinc_code: user.sinc_code,
                email: user.email,
                celular: user.cellphone,
                total_equipamentos: equipaments.length,
                alertas_portas: hasAlert,
                status: user.is_aproved,
                role: user.roles,
            };
        }));
        return hasEquipament;
    }
    async countAll() {
        const users = await this.usersRepository.count();
        return users;
    }
    async resetPassword(resetDto) {
        const { email, code, newPassword } = resetDto;
        const resetToken = await this.resetTokenRepository.findOne({
            where: {
                code,
                used: false,
                expires_at: (0, typeorm_2.MoreThan)(new Date()),
                user: { email },
            },
            relations: ['user'],
        });
        if (!resetToken) {
            throw new common_2.BadRequestException('Código de recuperação inválido ou expirado.');
        }
        const user = resetToken.user;
        user.password = await bcrypt.hash(newPassword, 10);
        await this.usersRepository.save(user);
        resetToken.used = true;
        await this.resetTokenRepository.save(resetToken);
        return { message: 'Senha redefinida com sucesso.' };
    }
    async changeUserPassword(id, updateUserPasswordDto) {
        const user = await this.usersRepository.findOneBy({ id });
        if (user &&
            bcrypt.compareSync(updateUserPasswordDto.current_password, user.password)) {
            try {
                user.password = await bcrypt.hash(updateUserPasswordDto.new_password, 10);
                await this.usersRepository.update(user.id, user);
                return 'Senha alterada com sucesso';
            }
            catch (error) {
                throw new common_2.BadRequestException({
                    message: 'Erro ao tentar trocar a senha do usuário.' + error,
                });
            }
        }
        throw new common_2.BadRequestException('Erro ao tentar alterar a senha');
    }
    async updateUserStatus(id, aproved) {
        const user = await this.usersRepository.findOneBy({ id });
        if (!user) {
            throw new common_2.NotFoundException('Usuário não encontrado');
        }
        let message;
        aproved
            ? ((user.is_aproved = true),
                (message =
                    'Status do código de sincronização do usuário alterado para aprovado'))
            : ((user.is_aproved = false),
                (message =
                    'Status do código de sincronização do usário alterado para reprovado'));
        try {
            user.is_aproved = user.is_aproved != aproved ? aproved : user.is_aproved;
            await this.usersRepository.save(user);
        }
        catch (error) {
            throw new common_2.BadRequestException('Erro ao tentar mudar o status do usuário. \n Erro: ' + error);
        }
        return message;
    }
    async update(id, updateUserDto) {
        const user = await this.usersRepository.findOneBy({ id });
        if (!user) {
            throw new common_2.NotFoundException('Usuário não encontrado');
        }
        if (updateUserDto.password) {
            try {
                const hashedPassword = await bcrypt.hash(updateUserDto.password, 10);
                updateUserDto.password = hashedPassword;
            }
            catch (error) {
                throw new common_2.BadRequestException('Erro ao atualizar senha');
            }
        }
        try {
            this.usersRepository.merge(user, updateUserDto);
            await this.usersRepository.save(user);
        }
        catch (error) {
            throw new common_2.BadRequestException('Erro durante a atualização dos dados do usuário. ' + error);
        }
        return 'Usuário atualizado com sucesso';
    }
    async remove(id) {
        const user = await this.usersRepository.findOneBy({ id });
        if (!user) {
            throw new common_2.NotFoundException({ message: 'Usuário não encontrado' });
        }
        try {
            await this.usersRepository.remove(user);
        }
        catch (error) {
            console.log(error);
            throw new common_2.BadRequestException('Erro ao tentar deletar o usuário. ' + error);
        }
        return { message: 'Usuário deletado com sucesso' };
    }
    async findUserById(userId) {
        const user = await this.usersRepository.findOneBy({ id: userId });
        if (!user) {
            throw new common_2.NotFoundException('Usuário não encontrado');
        }
        return user;
    }
    async findUserWithoutRestricData(id) {
        const user = await this.usersRepository.findOne({
            where: { ...id },
            select: [
                'id',
                'document',
                'company_name',
                'user_name',
                'email',
                'roles',
                'cellphone',
                'maintanance_notf',
                'alert_notf',
                'sinc_code',
                'is_aproved',
            ],
        });
        if (!user) {
            throw new common_2.NotFoundException('Usuário não encontrado');
        }
        return user;
    }
};
exports.UsersService = UsersService;
exports.UsersService = UsersService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __param(1, (0, typeorm_1.InjectRepository)(password_reset_token_entity_1.PasswordResetToken)),
    __param(2, (0, typeorm_1.InjectRepository)(equipament_entity_1.Equipament)),
    __param(3, (0, typeorm_1.InjectRepository)(door_entity_1.Door)),
    __param(4, (0, common_2.Inject)((0, common_2.forwardRef)(() => auth_service_1.AuthService))),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        auth_service_1.AuthService,
        event_emitter_1.EventEmitter2])
], UsersService);
//# sourceMappingURL=users.service.js.map