"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelsController = void 0;
const common_2 = require("@nestjs/common");
const models_service_1 = require("./models.service");
const create_model_dto_1 = require("./dto/create-model.dto");
const update_model_dto_1 = require("./dto/update-model.dto");
const auth_guard_1 = require("../../shared/auth/auth.guard");
const enum_1 = require("../../shared/enums/enum");
const required_roles_decorator_1 = require("../../shared/auth/required-roles.decorator");
const role_guard_1 = require("../../shared/auth/role/role.guard");
const swagger_2 = require("@nestjs/swagger");
let ModelsController = class ModelsController {
    modelsService;
    constructor(modelsService) {
        this.modelsService = modelsService;
    }
    create(createModelDto) {
        return this.modelsService.create(createModelDto);
    }
    findAll() {
        return this.modelsService.findAll();
    }
    findOne(id) {
        return this.modelsService.findOne(+id);
    }
    update(id, updateModelDto) {
        return this.modelsService.update(+id, updateModelDto);
    }
    remove(id) {
        return this.modelsService.remove(+id);
    }
};
exports.ModelsController = ModelsController;
__decorate([
    (0, common_2.Post)('/registro'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN),
    __param(0, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_model_dto_1.CreateModelDto]),
    __metadata("design:returntype", void 0)
], ModelsController.prototype, "create", null);
__decorate([
    (0, common_2.Get)(),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ModelsController.prototype, "findAll", null);
__decorate([
    (0, common_2.Get)(':id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ModelsController.prototype, "findOne", null);
__decorate([
    (0, common_2.Patch)(':id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_model_dto_1.UpdateModelDto]),
    __metadata("design:returntype", void 0)
], ModelsController.prototype, "update", null);
__decorate([
    (0, common_2.Delete)(':id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ModelsController.prototype, "remove", null);
exports.ModelsController = ModelsController = __decorate([
    (0, swagger_2.ApiTags)('Modelo dos Equipamentos'),
    (0, common_2.Controller)('modelo'),
    __metadata("design:paramtypes", [models_service_1.ModelsService])
], ModelsController);
//# sourceMappingURL=models.controller.js.map