"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsaasModule = void 0;
const common_2 = require("@nestjs/common");
const axios_1 = require("@nestjs/axios");
const asaas_service_1 = require("./asaas.service");
const asaas_controller_1 = require("./asaas.controller");
const asaas_gateway_1 = require("./asaas.gateway");
const typeorm_1 = require("@nestjs/typeorm");
const user_entity_1 = require("../../shared/users/entities/user.entity");
const order_entity_1 = require("../orders/entities/order.entity");
const course_payment_entity_1 = require("../course_payment/entities/course_payment.entity");
const orders_module_1 = require("../orders/orders.module");
const jwt_1 = require("@nestjs/jwt");
const creditcard_entity_1 = require("../creditcard/entities/creditcard.entity");
let AsaasModule = class AsaasModule {
};
exports.AsaasModule = AsaasModule;
exports.AsaasModule = AsaasModule = __decorate([
    (0, common_2.Module)({
        imports: [axios_1.HttpModule, (0, common_2.forwardRef)(() => orders_module_1.OrdersModule),
            typeorm_1.TypeOrmModule.forFeature([user_entity_1.User, order_entity_1.Order, course_payment_entity_1.Course_payment, creditcard_entity_1.Creditcard]),
            jwt_1.JwtModule.register({
                secret: process.env.JWT_SECRET || 'secret'
            })
        ],
        providers: [asaas_service_1.AsaasService, asaas_gateway_1.AsaasGateway],
        controllers: [asaas_controller_1.AsaasController],
        exports: [asaas_service_1.AsaasService],
    })
], AsaasModule);
//# sourceMappingURL=asaas.module.js.map