"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductsService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const product_entity_1 = require("./entities/product.entity");
const typeorm_2 = require("typeorm");
const client_s3_1 = require("@aws-sdk/client-s3");
let ProductsService = class ProductsService {
    productRepository;
    constructor(productRepository) {
        this.productRepository = productRepository;
    }
    s3 = new client_s3_1.S3Client({
        region: process.env.AWS_S3_REGION,
        credentials: {
            accessKeyId: process.env.AWS_ACCESS_KEY_ID,
            secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY,
        },
    });
    async create(createProductDto) {
        const product = await this.productRepository.findOne({
            where: {
                cod_product: createProductDto.cod_product
            }
        });
        if (product) {
            throw new common_2.ConflictException("Ops. Já existe um produto com esse código");
        }
        return await this.productRepository.save(this.productRepository.create(createProductDto));
    }
    findAll() {
        return this.productRepository.find();
    }
    findAllForManagement() {
        return this.productRepository.find();
    }
    async findOneForManagement() {
        return this.productRepository.find();
    }
    async findOne(productId) {
        const product = await this.productRepository.findOneBy({ id: productId });
        if (!product) {
            throw new common_2.NotFoundException("Ops. Produto não encontrado");
        }
        return product;
    }
    async update(productId, updateProductDto) {
        const product = await this.findProductById(productId);
        const productUpdated = this.productRepository.merge(product, updateProductDto);
        try {
            await this.productRepository.save(productUpdated);
        }
        catch (error) {
            throw new common_2.BadRequestException("Erro ao tentar atualizar um ou mais dados do produto. Error: ", error);
        }
        return { message: "Produto atualziado com sucesso" };
    }
    async remove(productId) {
        const product = await this.findProductById(productId);
        try {
            await this.productRepository.remove(product);
        }
        catch (error) {
            console.log(error);
            throw new common_2.BadRequestException("Erro ao tentar remover o produto. Erro", error);
        }
        return { message: "Produto removido com sucesso" };
    }
    async findProductById(productId) {
        const product = await this.productRepository.findOneBy({ id: productId });
        if (!product) {
            throw new common_2.NotFoundException("Produto não encontrado");
        }
        return product;
    }
    async uploadImageToS3(file, fileName) {
        const bucketName = process.env.AWS_S3_BUCKET;
        const uploadParams = new client_s3_1.PutObjectCommand({
            Bucket: bucketName,
            Key: fileName,
            Body: file.buffer,
            ContentType: file.mimetype,
        });
        console.log(uploadParams);
        try {
            await this.s3.send(uploadParams);
            return `https://${bucketName}.s3.${process.env.AWS_S3_REGION}.amazonaws.com/${fileName}`;
        }
        catch (err) {
            throw new common_2.BadRequestException('Erro ao enviar arquivo para o S3: ' + err);
        }
    }
};
exports.ProductsService = ProductsService;
exports.ProductsService = ProductsService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(product_entity_1.Product)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], ProductsService);
//# sourceMappingURL=products.service.js.map