"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShoppingCartModule = void 0;
const common_2 = require("@nestjs/common");
const shopping_cart_service_1 = require("./shopping_cart.service");
const shopping_cart_controller_1 = require("./shopping_cart.controller");
const typeorm_1 = require("@nestjs/typeorm");
const order_entity_1 = require("../orders/entities/order.entity");
const users_module_1 = require("../../shared/users/users.module");
const order_transaction_entity_1 = require("../orders/entities/order_transaction.entity");
const jwt_1 = require("@nestjs/jwt");
const products_module_1 = require("../products/products.module");
const order_product_entity_1 = require("../orders/entities/order_product.entity");
const cupom_entity_1 = require("../cupom/entities/cupom.entity");
let ShoppingCartModule = class ShoppingCartModule {
};
exports.ShoppingCartModule = ShoppingCartModule;
exports.ShoppingCartModule = ShoppingCartModule = __decorate([
    (0, common_2.Module)({
        imports: [
            users_module_1.UsersModule, products_module_1.ProductsModule,
            typeorm_1.TypeOrmModule.forFeature([order_entity_1.Order, order_transaction_entity_1.OrderTransactions, order_product_entity_1.OrderProduct, cupom_entity_1.Cupom]),
            jwt_1.JwtModule.register({
                secret: process.env.JWT_SECRET || 'secret'
            })
        ],
        controllers: [shopping_cart_controller_1.ShoppingCartController],
        providers: [shopping_cart_service_1.ShoppingCartService],
        exports: [shopping_cart_service_1.ShoppingCartService]
    })
], ShoppingCartModule);
//# sourceMappingURL=shopping_cart.module.js.map