"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthController = void 0;
const common_2 = require("@nestjs/common");
const auth_service_1 = require("./auth.service");
const swagger_2 = require("@nestjs/swagger");
const auth_dto_1 = require("./dto/auth.dto");
let AuthController = class AuthController {
    authService;
    constructor(authService) {
        this.authService = authService;
    }
    async login(body) {
        if (!body.email || !body.password) {
            return { message: 'Informe e-mail e senha para efetuar o login' };
        }
        const user = await this.authService.validateUser(body.email, body.password);
        if (user) {
            return this.authService.login(user);
        }
        throw new common_2.NotFoundException('Usuário ou senha inválidos');
    }
};
exports.AuthController = AuthController;
__decorate([
    (0, swagger_2.ApiOperation)({ summary: 'Faz login na aplicação', description: 'Verifica se o e-mail ou senha estão cadastrados no banco de dados' }),
    (0, swagger_2.ApiResponse)({ status: 200, description: 'Autentica o usuário e retorna o token JWT' }),
    (0, swagger_2.ApiResponse)({ status: 404, description: 'Registro de usuário não encontrado',
        schema: {
            type: 'object',
            properties: {
                message: { type: 'string', example: 'E-mail válido' },
                error: { type: 'string', example: 'Não encontrado' },
                statusCode: { type: 'number', example: 404 }
            },
        },
    }),
    (0, common_2.Post)('login'),
    __param(0, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.authLoginDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "login", null);
exports.AuthController = AuthController = __decorate([
    (0, swagger_2.ApiTags)('Autenticação'),
    (0, common_2.Controller)('auth'),
    __metadata("design:paramtypes", [auth_service_1.AuthService])
], AuthController);
//# sourceMappingURL=auth.controller.js.map