"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateUserPasswordDto = exports.UpdateUserDto = void 0;
const class_validator_1 = require("class-validator");
const swagger_2 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const enum_1 = require("../../enums/enum");
class UpdateUserDto {
    company_name;
    user_name;
    document;
    email;
    cellphone;
    maintanance_notf;
    alert_notf;
    is_aproved;
    roles;
    credit_card_number;
    credit_card_expiry_month;
    credit_card_expiry_year;
    credit_card_holder_name;
    ccv;
    password;
}
exports.UpdateUserDto = UpdateUserDto;
__decorate([
    (0, class_transformer_1.Transform)(({ value }) => value.toLowerCase()),
    (0, class_validator_1.IsString)({ message: 'O nome da empresa deve ser uma string.' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'O nome da empresa não pode estar vazio.' }),
    (0, class_validator_1.MinLength)(3, {
        message: 'O nome da empresa deve ter no mínimo 3 caracteres.',
    }),
    __metadata("design:type", String)
], UpdateUserDto.prototype, "company_name", void 0);
__decorate([
    (0, class_transformer_1.Transform)(({ value }) => value.toLowerCase()),
    (0, class_validator_1.IsString)({ message: 'O nome deve ser uma string.' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'O nome não pode estar vazio.' }),
    (0, class_validator_1.MinLength)(3, { message: 'O nome deve ter no mínimo 3 caracteres.' }),
    __metadata("design:type", String)
], UpdateUserDto.prototype, "user_name", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)({ message: 'O documento deve ser uma string.' }),
    __metadata("design:type", String)
], UpdateUserDto.prototype, "document", void 0);
__decorate([
    (0, class_transformer_1.Transform)(({ value }) => value.toLowerCase()),
    (0, class_validator_1.IsEmail)({}, { message: 'Por favor, forneça um endereço de e-mail válido.' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'O e-mail não pode estar vazio.' }),
    __metadata("design:type", String)
], UpdateUserDto.prototype, "email", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)({ message: 'O celular deve ser uma string.' }),
    __metadata("design:type", String)
], UpdateUserDto.prototype, "cellphone", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Boolean)
], UpdateUserDto.prototype, "maintanance_notf", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Boolean)
], UpdateUserDto.prototype, "alert_notf", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Boolean)
], UpdateUserDto.prototype, "is_aproved", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(enum_1.Roles),
    __metadata("design:type", String)
], UpdateUserDto.prototype, "roles", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)({ message: 'O número do cartão de crédito deve ser uma string.' }),
    __metadata("design:type", String)
], UpdateUserDto.prototype, "credit_card_number", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)({
        message: 'O mês de expiração do cartão de crédito deve ser uma string.',
    }),
    __metadata("design:type", String)
], UpdateUserDto.prototype, "credit_card_expiry_month", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)({
        message: 'O ano de expiração do cartão de crédito deve ser uma string.',
    }),
    __metadata("design:type", String)
], UpdateUserDto.prototype, "credit_card_expiry_year", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)({
        message: 'O nome do titular do cartão de crédito deve ser uma string.',
    }),
    __metadata("design:type", String)
], UpdateUserDto.prototype, "credit_card_holder_name", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)({
        message: 'O código de segurança (CCV) do cartão de crédito deve ser uma string.',
    }),
    __metadata("design:type", String)
], UpdateUserDto.prototype, "ccv", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], UpdateUserDto.prototype, "password", void 0);
class UpdateUserPasswordDto {
    current_password;
    new_password;
}
exports.UpdateUserPasswordDto = UpdateUserPasswordDto;
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], UpdateUserPasswordDto.prototype, "current_password", void 0);
__decorate([
    (0, swagger_2.ApiProperty)({
        description: 'O campo de senha do usuário',
        example: '123456',
    }),
    (0, class_validator_1.IsNotEmpty)({ message: 'O campo senha é obrigatório' }),
    (0, class_validator_1.IsStrongPassword)({ minLength: 6, minLowercase: 0, minUppercase: 0, minSymbols: 0 }, { message: 'A senha deve conter pelo menos 6 caracteres' }),
    __metadata("design:type", String)
], UpdateUserPasswordDto.prototype, "new_password", void 0);
//# sourceMappingURL=update-user.dto.js.map