"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersController = void 0;
const auth_guard_1 = require("../auth/auth.guard");
const common_2 = require("@nestjs/common");
const users_service_1 = require("./users.service");
const create_user_dto_1 = require("./dto/create-user.dto");
const update_user_dto_1 = require("./dto/update-user.dto");
const required_roles_decorator_1 = require("../auth/required-roles.decorator");
const enum_1 = require("../enums/enum");
const role_guard_1 = require("../auth/role/role.guard");
const permissions_guards_1 = require("../auth/permissions.guards");
const recover_password_dto_1 = require("./dto/recover-password.dto");
const current_user_decorator_1 = require("./current.user.decorator");
let UsersController = class UsersController {
    usersService;
    constructor(usersService) {
        this.usersService = usersService;
    }
    create(createUserDto) {
        return this.usersService.create(createUserDto);
    }
    forgotPassword(forgotPasswordDto) {
        return this.usersService.forgotPassword(forgotPasswordDto.email);
    }
    findUserWithoutRestricData(currentUser) {
        return this.usersService.findUserWithoutRestricData(currentUser.id);
    }
    findResume() {
        return this.usersService.findResume();
    }
    countAll() {
        return this.usersService.countAll();
    }
    findMyProfile(id) {
        return this.usersService.findMyProfile(+id);
    }
    findOne(id) {
        return this.usersService.findOne(+id);
    }
    updateUserStatus(id, aproved) {
        return this.usersService.updateUserStatus(+id, aproved);
    }
    resetPassword(resetPasswordDto) {
        return this.usersService.resetPassword(resetPasswordDto);
    }
    changeUserPassword(id, updateUserPasswordDto) {
        return this.usersService.changeUserPassword(+id, updateUserPasswordDto);
    }
    update(id, updateUserDto) {
        return this.usersService.update(+id, updateUserDto);
    }
    remove(id) {
        return this.usersService.remove(+id);
    }
};
exports.UsersController = UsersController;
__decorate([
    (0, common_2.Post)('/registro'),
    __param(0, (0, common_2.Body)(new common_2.ValidationPipe({ whitelist: true }))),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_user_dto_1.CreateUserDto]),
    __metadata("design:returntype", void 0)
], UsersController.prototype, "create", null);
__decorate([
    (0, common_2.Post)('esqueceu-senha'),
    __param(0, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [recover_password_dto_1.forgotPasswordDto]),
    __metadata("design:returntype", void 0)
], UsersController.prototype, "forgotPassword", null);
__decorate([
    (0, common_2.Get)('/me'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], UsersController.prototype, "findUserWithoutRestricData", null);
__decorate([
    (0, common_2.Get)('/'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], UsersController.prototype, "findResume", null);
__decorate([
    (0, common_2.Get)('/contagem-total'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], UsersController.prototype, "countAll", null);
__decorate([
    (0, common_2.Get)('my-profile/:id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], UsersController.prototype, "findMyProfile", null);
__decorate([
    (0, common_2.Get)(':id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], UsersController.prototype, "findOne", null);
__decorate([
    (0, common_2.Put)(':id/'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Query)('aproved', new common_2.ParseBoolPipe({ errorHttpStatusCode: 400 }))),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Boolean]),
    __metadata("design:returntype", void 0)
], UsersController.prototype, "updateUserStatus", null);
__decorate([
    (0, common_2.Patch)('alterar-senha'),
    __param(0, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [recover_password_dto_1.ResetPasswordDto]),
    __metadata("design:returntype", void 0)
], UsersController.prototype, "resetPassword", null);
__decorate([
    (0, common_2.Patch)('change-password/:id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_user_dto_1.UpdateUserPasswordDto]),
    __metadata("design:returntype", void 0)
], UsersController.prototype, "changeUserPassword", null);
__decorate([
    (0, common_2.Patch)(':id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_user_dto_1.UpdateUserDto]),
    __metadata("design:returntype", void 0)
], UsersController.prototype, "update", null);
__decorate([
    (0, common_2.Delete)(':id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], UsersController.prototype, "remove", null);
exports.UsersController = UsersController = __decorate([
    (0, common_2.Controller)('usuarios'),
    __metadata("design:paramtypes", [users_service_1.UsersService])
], UsersController);
//# sourceMappingURL=users.controller.js.map