"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CryptoUtil = void 0;
const crypto = require("crypto");
const ALGORITHM = 'aes-256-cbc';
const KEY = crypto.scryptSync(`${process.env.CRYPTO_SECRET_KEY}`, 'salt', 32);
const IV = 16;
class CryptoUtil {
    static encrypt(value) {
        if (!value)
            return value;
        const iv = crypto.randomBytes(IV);
        const cipher = crypto.createCipheriv(ALGORITHM, KEY, iv);
        const encrypted = Buffer.concat([cipher.update(value, 'utf8'), cipher.final()]);
        return iv.toString('hex') + ':' + encrypted.toString('hex');
    }
    static decrypt(value) {
        if (!value)
            return value;
        const [ivHex, encryptedHex] = value.split(':');
        const iv = Buffer.from(ivHex, 'hex');
        const encrypted = Buffer.from(encryptedHex, 'hex');
        const decipher = crypto.createDecipheriv(ALGORITHM, KEY, iv);
        const decrypted = Buffer.concat([decipher.update(encrypted), decipher.final()]);
        return decrypted.toString('utf8');
    }
}
exports.CryptoUtil = CryptoUtil;
//# sourceMappingURL=encrypt.js.map