"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateSchedulesByGroupDto = exports.UpdateSchedulesDto = exports.UpdateStatusDto = exports.UpdateEquipamentDto = void 0;
const mapped_types_1 = require("@nestjs/mapped-types");
const create_equipament_dto_1 = require("./create-equipament.dto");
const class_validator_1 = require("class-validator");
const swagger_2 = require("@nestjs/swagger");
class UpdateEquipamentDto extends (0, mapped_types_1.PartialType)(create_equipament_dto_1.CreateEquipamentDto) {
    equipament_name;
    section;
    sinc_code;
}
exports.UpdateEquipamentDto = UpdateEquipamentDto;
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'Nome do equipamento', example: 'Porta do Estoque de Produtos Acabados' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'O nome do equipamento é obrigatório' }),
    __metadata("design:type", String)
], UpdateEquipamentDto.prototype, "equipament_name", void 0);
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'Setor em que o equipamento encontra-se', example: 'Estoque de Produtos Acabados' }),
    __metadata("design:type", String)
], UpdateEquipamentDto.prototype, "section", void 0);
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'Código de sincronização entre o usuário e o equipamento', example: '#123456' }),
    __metadata("design:type", String)
], UpdateEquipamentDto.prototype, "sinc_code", void 0);
class UpdateStatusDto {
    mac_address;
    isOpen;
    hasAlert;
    cicle;
    operation_hours;
}
exports.UpdateStatusDto = UpdateStatusDto;
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: "O MAC do equipamento é obrigatório" }),
    (0, class_validator_1.IsString)({ message: "O MAC do equipamento deve ser uma string" }),
    __metadata("design:type", String)
], UpdateStatusDto.prototype, "mac_address", void 0);
class UpdateSchedulesDto {
    days_of_week;
    on_at;
    off_at;
    speed;
    direction;
    remote_enable;
}
exports.UpdateSchedulesDto = UpdateSchedulesDto;
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'Os dias da semana são obrigatórios' }),
    __metadata("design:type", String)
], UpdateSchedulesDto.prototype, "days_of_week", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'A hora para ligar é obrigatória' }),
    __metadata("design:type", String)
], UpdateSchedulesDto.prototype, "on_at", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'A hora para desligar é obrigatória' }),
    __metadata("design:type", String)
], UpdateSchedulesDto.prototype, "off_at", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'A valocidade é obrigatória' }),
    __metadata("design:type", String)
], UpdateSchedulesDto.prototype, "speed", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'A difereção da rotação é obrigatória' }),
    __metadata("design:type", String)
], UpdateSchedulesDto.prototype, "direction", void 0);
__decorate([
    (0, class_validator_1.IsBoolean)({ message: "A configuração de programação remota deve seu um booleano" }),
    __metadata("design:type", Boolean)
], UpdateSchedulesDto.prototype, "remote_enable", void 0);
class UpdateSchedulesByGroupDto {
    groupId;
    days_of_week;
    on_at;
    off_at;
    speed;
    direction;
    remote_enable;
}
exports.UpdateSchedulesByGroupDto = UpdateSchedulesByGroupDto;
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'O ID do grupo de equipamentos não pode ser vázio' }),
    (0, class_validator_1.IsPositive)({ message: 'O ID do grupo de equipamentos deve ser um número positivo' }),
    (0, class_validator_1.IsNumber)({}, { message: 'O ID do grupo de equipamentos deve ser um número válido' }),
    __metadata("design:type", Number)
], UpdateSchedulesByGroupDto.prototype, "groupId", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'Os dias da semana são obrigatórios' }),
    __metadata("design:type", String)
], UpdateSchedulesByGroupDto.prototype, "days_of_week", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'A hora para ligar é obrigatória' }),
    __metadata("design:type", String)
], UpdateSchedulesByGroupDto.prototype, "on_at", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'A hora para desligar é obrigatória' }),
    __metadata("design:type", String)
], UpdateSchedulesByGroupDto.prototype, "off_at", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'A valocidade é obrigatória' }),
    __metadata("design:type", String)
], UpdateSchedulesByGroupDto.prototype, "speed", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'A difereção da rotação é obrigatória' }),
    __metadata("design:type", String)
], UpdateSchedulesByGroupDto.prototype, "direction", void 0);
__decorate([
    (0, class_validator_1.IsBoolean)({ message: "A configuração de programação remota deve seu um booleano" }),
    __metadata("design:type", Boolean)
], UpdateSchedulesByGroupDto.prototype, "remote_enable", void 0);
//# sourceMappingURL=update-equipament.dto.js.map