"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Equipament = void 0;
const door_entity_1 = require("../../doors/entities/door.entity");
const industrial_fan_entity_1 = require("../../industrial_fans/entities/industrial_fan.entity");
const model_entity_1 = require("../../models/entities/model.entity");
const user_entity_1 = require("../../../shared/users/entities/user.entity");
const typeorm_1 = require("typeorm");
const group_entity_1 = require("../../group/entities/group.entity");
let Equipament = class Equipament {
    id;
    equipament_name;
    internal_id;
    mac_address;
    section;
    created_at;
    latest_maintanence;
    user;
    model;
    door;
    fan;
    group;
};
exports.Equipament = Equipament;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)({ type: 'smallint' }),
    __metadata("design:type", Number)
], Equipament.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "varchar", nullable: false, default: "Novo Equipamento" }),
    __metadata("design:type", String)
], Equipament.prototype, "equipament_name", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "varchar", nullable: false }),
    __metadata("design:type", String)
], Equipament.prototype, "internal_id", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', nullable: false }),
    __metadata("design:type", String)
], Equipament.prototype, "mac_address", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "varchar", nullable: false, default: "Não definido" }),
    __metadata("design:type", String)
], Equipament.prototype, "section", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp', default: () => 'CURRENT_TIMESTAMP' }),
    __metadata("design:type", Date)
], Equipament.prototype, "created_at", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp', default: () => 'CURRENT_TIMESTAMP' }),
    __metadata("design:type", Date)
], Equipament.prototype, "latest_maintanence", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.User, (user) => user.equipament, { onDelete: 'SET NULL', nullable: true }),
    __metadata("design:type", Object)
], Equipament.prototype, "user", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => model_entity_1.Model, (model) => model.equipament, { nullable: false }),
    __metadata("design:type", model_entity_1.Model)
], Equipament.prototype, "model", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => door_entity_1.Door, (door) => door.equipament, { nullable: true, cascade: true }),
    __metadata("design:type", Object)
], Equipament.prototype, "door", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => industrial_fan_entity_1.IndustrialFan, (industrial_fan) => industrial_fan.equipament, { nullable: true, cascade: true }),
    __metadata("design:type", Object)
], Equipament.prototype, "fan", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => group_entity_1.Group, (group) => group.equipament, { onDelete: 'SET NULL', nullable: true }),
    __metadata("design:type", Object)
], Equipament.prototype, "group", void 0);
exports.Equipament = Equipament = __decorate([
    (0, typeorm_1.Entity)()
], Equipament);
//# sourceMappingURL=equipament.entity.js.map