"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const group_entity_1 = require("./entities/group.entity");
let GroupService = class GroupService {
    groupRepository;
    constructor(groupRepository) {
        this.groupRepository = groupRepository;
    }
    async create(createGroupDto, currentUserId) {
        const group = this.groupRepository.create({
            ...createGroupDto,
            user: { id: currentUserId },
        });
        await this.groupRepository.save(group);
        return { message: "Novo grupo criado com sucesso" };
    }
    async findAllByUser(currentUserId) {
        const group = await this.groupRepository.find({
            where: { user: { id: currentUserId } },
            relations: ['equipament'],
        });
        return (group.length === 0) ? { message: "Você ainda não possui grupos de equipamentos" } : group;
    }
    async findOne(id, currentUserId) {
        const group = await this.groupRepository.findOne({
            where: { id, user: { id: currentUserId } },
            relations: ['equipament'],
        });
        if (!group) {
            throw new common_2.NotFoundException(`Grupo com ID "${id}" não encontrado ou não pertence a este usuário.`);
        }
        return group;
    }
    async update(id, updateGroupDto, userId) {
        const group = await this.findOne(id, userId);
        const updatedGroup = this.groupRepository.merge(group, updateGroupDto);
        await this.groupRepository.save(updatedGroup);
        return { message: "Grupo atualizado com sucesso" };
    }
    async remove(id, userId) {
        const group = await this.findOne(id, userId);
        await this.groupRepository.remove(group);
        return { message: `Grupo "${group.group_name}" removido com sucesso.` };
    }
};
exports.GroupService = GroupService;
exports.GroupService = GroupService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(group_entity_1.Group)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], GroupService);
//# sourceMappingURL=group.service.js.map