"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsaasController = void 0;
const common_2 = require("@nestjs/common");
const asaas_service_1 = require("./asaas.service");
const current_user_decorator_1 = require("../../shared/users/current.user.decorator");
const auth_guard_1 = require("../../shared/auth/auth.guard");
let AsaasController = class AsaasController {
    asaasService;
    constructor(asaasService) {
        this.asaasService = asaasService;
    }
    handleWebHook(body, headers) {
        console.log('Webhook recebido. Body:', body);
        return this.asaasService.handlePaymentWebhook(body);
    }
    getPixQrCode(paymentId) {
        return this.asaasService.getPixQrCode(paymentId);
    }
    async getUserSubscriptions(userId) {
        try {
            const subscriptions = await this.asaasService.getUserSubscriptions(userId);
            return {
                success: true,
                total: subscriptions.length,
                data: subscriptions,
            };
        }
        catch (error) {
            console.error('Erro no controller:', error.message);
            throw new common_2.HttpException({
                success: false,
                message: 'Erro ao buscar assinaturas do usuário',
                details: error.response?.data || error.message,
            }, common_2.HttpStatus.BAD_REQUEST);
        }
    }
    fakePayment(orderId, currentUser) {
        return this.asaasService.fakePayment(currentUser.id, +orderId);
    }
    createSubscription(currentUser) {
        return this.asaasService.createSubscription(currentUser.id);
    }
    paySubscription(currentUser) {
        return this.asaasService.paySubscription(+currentUser.id);
    }
};
exports.AsaasController = AsaasController;
__decorate([
    (0, common_2.Post)(),
    (0, common_2.HttpCode)(200),
    __param(0, (0, common_2.Body)()),
    __param(1, (0, common_2.Headers)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], AsaasController.prototype, "handleWebHook", null);
__decorate([
    (0, common_2.Get)(':paymentId/qrcode'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('paymentId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AsaasController.prototype, "getPixQrCode", null);
__decorate([
    (0, common_2.Get)('subscriptions/:userId'),
    __param(0, (0, common_2.Param)('userId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AsaasController.prototype, "getUserSubscriptions", null);
__decorate([
    (0, common_2.Patch)(':orderId/simular-pagamento'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('orderId')),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], AsaasController.prototype, "fakePayment", null);
__decorate([
    (0, common_2.Post)('/Teste'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AsaasController.prototype, "createSubscription", null);
__decorate([
    (0, common_2.Post)('/assinar'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AsaasController.prototype, "paySubscription", null);
exports.AsaasController = AsaasController = __decorate([
    (0, common_2.Controller)('asaas'),
    __metadata("design:paramtypes", [asaas_service_1.AsaasService])
], AsaasController);
//# sourceMappingURL=asaas.controller.js.map