import { CourseService } from './courses.service';
export declare class CourseController {
    private readonly courseService;
    constructor(courseService: CourseService);
    create(body: any, file: Express.Multer.File): Promise<import("./entites/courses.entity").Course>;
    completeLesson(courseId: number, classId: number, user: any): Promise<{
        completed: boolean;
    }>;
    courseProgress(courseId: number, user: any): Promise<any>;
    findAllByUser(user: any): Promise<any[]>;
    findOneByUser(courseId: number, user: any): Promise<{
        hasAccess: boolean;
        id: number;
        title: string;
        description: string;
        category: string;
        status: string;
        thumbnail: string;
        level: string;
        price: number;
        urls: string[];
        classes: import("../videos/entities/class.entity").Class[];
        payments: import("../course_payment/entities/course_payment.entity").Course_payment[];
    }>;
    findAll(): Promise<import("./entites/courses.entity").Course[]>;
    findAllForManagement(): Promise<import("./entites/courses.entity").Course[]>;
    findOne(id: string): Promise<{
        lessons: import("../videos/entities/class.entity").Class[];
        id: number;
        title: string;
        description: string;
        category: string;
        status: string;
        thumbnail: string;
        level: string;
        price: number;
        urls: string[];
        payments: import("../course_payment/entities/course_payment.entity").Course_payment[];
    }>;
    findOneForManagement(): Promise<import("./entites/courses.entity").Course[]>;
    update(id: string, body: {
        data: string;
    }, file?: Express.Multer.File): Promise<import("./entites/courses.entity").Course>;
    remove(id: string): Promise<{
        message: string;
    }>;
    findCourseWithClasses(): Promise<import("./entites/courses.entity").Course[]>;
    findCourseByIdWithClasses(id: number): Promise<import("./entites/courses.entity").Course[]>;
}
