import { Repository } from 'typeorm';
import { Course } from './entites/courses.entity';
import { CreateCourseDto } from './dto/create-courses.dto';
import { UpdateCourseDto } from './dto/update-courses.dto';
import { Class } from '../videos/entities/class.entity';
import { User } from 'src/shared/users/entities/user.entity';
import { Course_payment } from '../course_payment/entities/course_payment.entity';
import { CourseLessonProgress } from './entites/course_lesson_progress.entity';
export declare class CourseService {
    private courseRepository;
    private classRepository;
    private userRepository;
    private course_paymentRepository;
    private courseLessonProgressRepository;
    constructor(courseRepository: Repository<Course>, classRepository: Repository<Class>, userRepository: Repository<User>, course_paymentRepository: Repository<Course_payment>, courseLessonProgressRepository: Repository<CourseLessonProgress>);
    private s3;
    create(createCourseDto: CreateCourseDto): Promise<Course>;
    findAll(): Promise<Course[]>;
    findAllByUser(CurrentUser: any): Promise<any[]>;
    findOneByUser(courseId: number, CurrentUser: any): Promise<{
        hasAccess: boolean;
        id: number;
        title: string;
        description: string;
        category: string;
        status: string;
        thumbnail: string;
        level: string;
        price: number;
        urls: string[];
        classes: Class[];
        payments: Course_payment[];
    }>;
    findAllForManagement(): Promise<Course[]>;
    findOneForManagement(): Promise<Course[]>;
    findOne(courseId: number): Promise<{
        lessons: Class[];
        id: number;
        title: string;
        description: string;
        category: string;
        status: string;
        thumbnail: string;
        level: string;
        price: number;
        urls: string[];
        payments: Course_payment[];
    }>;
    uploadImageToS3(file: Express.Multer.File, fileName: string): Promise<string>;
    update(courseId: number, updateCourseDto: UpdateCourseDto): Promise<Course>;
    remove(courseId: number): Promise<{
        message: string;
    }>;
    findCourseById(courseId: number): Promise<Course>;
    findCourseWithClasses(): Promise<Course[]>;
    findCourseByIdWithClasses(id: number): Promise<Course[]>;
    completeLesson(courseId: number, classId: number, CurrentUser: any): Promise<{
        completed: boolean;
    }>;
    courseProgress(CurrentUser: any, courseId: number): Promise<any>;
}
