"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreditcardService = void 0;
const common_2 = require("@nestjs/common");
const user_entity_1 = require("../../shared/users/entities/user.entity");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const creditcard_entity_1 = require("./entities/creditcard.entity");
const encrypt_1 = require("../../utils/encrypt");
let CreditcardService = class CreditcardService {
    creditcardRepository;
    usersRepository;
    constructor(creditcardRepository, usersRepository) {
        this.creditcardRepository = creditcardRepository;
        this.usersRepository = usersRepository;
    }
    async create(createCreditcardDto, currentUser) {
        const user = await this.usersRepository.findOneBy({ id: currentUser.id });
        if (!user) {
            throw new common_2.NotFoundException('Usuário não encontrado.');
        }
        const cardNumber = createCreditcardDto.credit_card_number;
        const lastFourDigits = cardNumber.slice(-4);
        const encryptedCardNumber = await encrypt_1.CryptoUtil.encrypt(cardNumber);
        const cardExist = await this.creditcardRepository.findOneBy({ credit_card_number: encryptedCardNumber, user: { id: user.id } });
        if (cardExist) {
            throw new common_2.ConflictException("Cartão já cadastrado para este usuário");
        }
        const newCard = this.creditcardRepository.create({
            ...createCreditcardDto,
            last_four_digits: lastFourDigits,
            credit_card_holder_name: await encrypt_1.CryptoUtil.encrypt(createCreditcardDto.credit_card_holder_name),
            credit_card_number: encryptedCardNumber,
            credit_card_expiry_month: await encrypt_1.CryptoUtil.encrypt(createCreditcardDto.credit_card_expiry_month),
            credit_card_expiry_year: await encrypt_1.CryptoUtil.encrypt(createCreditcardDto.credit_card_expiry_year),
            ccv: await encrypt_1.CryptoUtil.encrypt(createCreditcardDto.ccv),
            user: user,
        });
        return this.creditcardRepository.save(newCard);
    }
    async findAll(currentUser) {
        const existCard = await this.creditcardRepository.find({
            where: { user: { id: currentUser.id } },
        });
        if (!existCard) {
            throw new common_2.NotFoundException("Cartão nenhum cartão encontrado");
        }
        return existCard;
    }
    async findLastCardRegister(currentUser) {
        const existCard = await this.creditcardRepository.findOne({
            where: { user: { id: currentUser.id } },
            order: { id: 'DESC' },
        });
        if (!existCard) {
            throw new common_2.NotFoundException("Nenhum cartão encontrado");
        }
        return existCard;
    }
    update(id, updateCreditcardDto) {
        const existCard = this.creditcardRepository.findOneBy({ id });
        if (!existCard) {
            throw new common_2.NotFoundException("Cartão não encontrado");
        }
        return this.creditcardRepository.update(id, updateCreditcardDto);
    }
    remove(id) {
        const existCard = this.creditcardRepository.findOneBy({ id });
        if (!existCard) {
            throw new common_2.NotFoundException("Cartão não encontrado");
        }
        try {
            return this.creditcardRepository.delete(id);
        }
        catch (error) {
            throw new common_2.NotFoundException("Erro ao tentar deletar o cartão");
        }
    }
};
exports.CreditcardService = CreditcardService;
exports.CreditcardService = CreditcardService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(creditcard_entity_1.Creditcard)),
    __param(1, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], CreditcardService);
//# sourceMappingURL=creditcard.service.js.map