"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashboardService = void 0;
const common_2 = require("@nestjs/common");
const user_entity_1 = require("../../shared/users/entities/user.entity");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const order_entity_1 = require("../orders/entities/order.entity");
const dayjs = require("dayjs");
const course_payment_entity_1 = require("../course_payment/entities/course_payment.entity");
let DashboardService = class DashboardService {
    orderRepository;
    coursePaymentRepository;
    userRepository;
    constructor(orderRepository, coursePaymentRepository, userRepository) {
        this.orderRepository = orderRepository;
        this.coursePaymentRepository = coursePaymentRepository;
        this.userRepository = userRepository;
    }
    async findAllRecentTransactions() {
        const last12Months = Array.from({ length: 12 }).map((_, i) => {
            const date = dayjs().subtract(i, 'month');
            return {
                date: date.format('YYYY-MM'),
                month: date.format('MMM/YY'),
                total: 0,
            };
        }).reverse();
        const startDate = dayjs().subtract(11, 'month').startOf('month').format('YYYY-MM-DD');
        const [recentOrders, recentCoursePayments, totals, coursePaymentTotals, dailySales, dailyCoursePaymentSales] = await Promise.all([
            this.orderRepository.createQueryBuilder('order')
                .innerJoinAndSelect('order.user', 'user')
                .select([
                'order.id AS id',
                'user.user_name AS name',
                'user.email AS email',
                'order.status AS status',
                'order.created_at AS created_at',
                'order.payment_method AS payment_method',
                'order.total_amount AS total_amount',
            ])
                .addSelect("'order' AS transaction_type")
                .orderBy('order.created_at', 'DESC')
                .limit(10)
                .getRawMany(),
            this.coursePaymentRepository.createQueryBuilder('course_payment')
                .innerJoinAndSelect('course_payment.user', 'user')
                .select([
                'course_payment.id as id', 'user.user_name as name', 'user.email as email', 'course_payment.status as status', 'course_payment.created_at as created_at', 'course_payment.amount as total_amount'
            ])
                .addSelect("'course_payment' AS transaction_type")
                .orderBy('course_payment.created_at', 'DESC')
                .limit(10)
                .getRawMany(),
            this.orderRepository.createQueryBuilder('order')
                .select([
                'SUM(order.total_amount) AS totalEcommerce',
                '(SELECT SUM(total_amount) FROM `order` WHERE DATE(created_at) = CURDATE()) AS totalDay',
                '(SELECT SUM(total_amount) FROM `order` WHERE YEAR(created_at) = YEAR(NOW()) AND MONTH(created_at) = MONTH(NOW()) AND status= "finalizado") AS totalMonthOrder'
            ])
                .getRawOne(),
            this.coursePaymentRepository.createQueryBuilder('course_payment')
                .select([
                'SUM(course_payment.amount) AS totalCoursePayment',
                '(SELECT SUM(amount) FROM `course_payment` WHERE YEAR(created_at) = YEAR(NOW()) AND MONTH(created_at) = MONTH(NOW()) AND status = "PAID") AS totalMonthCourse'
            ])
                .getRawOne(),
            this.orderRepository.createQueryBuilder('order')
                .select("DATE_FORMAT(order.created_at, '%Y-%m')", 'date')
                .addSelect('SUM(order.total_amount)', 'total')
                .where('order.created_at >= :startDate', { startDate })
                .andWhere('order.status = "finalizado"')
                .groupBy("DATE_FORMAT(order.created_at, '%Y-%m')")
                .orderBy('date', 'ASC')
                .getRawMany(),
            this.coursePaymentRepository.createQueryBuilder('course_payment')
                .select("DATE_FORMAT(course_payment.created_at, '%Y-%m')", 'date')
                .addSelect('SUM(course_payment.amount)', 'total')
                .where('course_payment.created_at >= :startDate', { startDate })
                .andWhere('course_payment.status = "PAID"')
                .groupBy("DATE_FORMAT(course_payment.created_at, '%Y-%m')")
                .orderBy('date', 'ASC')
                .getRawMany(),
        ]);
        const recentTransactions = [...recentOrders, ...recentCoursePayments]
            .sort((a, b) => new Date(b.created_at).getTime() - new Date(a.created_at).getTime())
            .slice(0, 10);
        const combinedDailySales = [...dailySales, ...dailyCoursePaymentSales];
        const dailyTotals = combinedDailySales.reduce((acc, sale) => {
            const date = sale.date;
            acc[date] = (acc[date] || 0) + Number(sale.total);
            return acc;
        }, {});
        last12Months.forEach(month => {
            if (dailyTotals[month.date]) {
                month.total = dailyTotals[month.date];
            }
        });
        return {
            recentTransactions,
            totalMonth: Number(totals?.totalMonthOrder ?? 0) + Number(coursePaymentTotals?.totalMonthCourse ?? 0),
            totalEcommerce: Number(totals?.totalEcommerce ?? 0),
            totalEcommerceMonth: Number(totals?.totalMonthOrder ?? 0),
            totalCoursePaymentMonth: Number(coursePaymentTotals?.totalMonthCourse ?? 0),
            totalCoursePayment: Number(coursePaymentTotals?.totalCoursePayment ?? 0),
            last12MonthsSales: last12Months,
        };
    }
    async findAllTransactions() {
        const [recentOrders, recentCoursePayments, totals, coursePaymentTotals,] = await Promise.all([
            this.orderRepository.createQueryBuilder('order')
                .innerJoinAndSelect('order.user', 'user')
                .select([
                'order.id AS id',
                'user.user_name AS name',
                'user.email AS email',
                'order.status AS status',
                'order.created_at AS created_at',
                'order.payment_method AS payment_method',
                'order.total_amount AS total_amount',
            ])
                .addSelect("'order' AS transaction_type")
                .orderBy('order.created_at', 'DESC')
                .where('status = "finalizado"')
                .getRawMany(),
            this.coursePaymentRepository.createQueryBuilder('course_payment')
                .innerJoinAndSelect('course_payment.user', 'user')
                .select([
                'course_payment.id as id', 'user.user_name as name', 'user.email as email', 'course_payment.status as status', 'course_payment.created_at as created_at', 'course_payment.amount as total_amount'
            ])
                .addSelect("'course_payment' AS transaction_type")
                .orderBy('course_payment.created_at', 'DESC')
                .where('status = "PAID"')
                .getRawMany(),
            this.orderRepository.createQueryBuilder('order')
                .select([
                'SUM(order.total_amount) AS totalEcommerce',
                '(SELECT SUM(total_amount) FROM `order` WHERE DATE(created_at) = CURDATE()) AS totalDay',
                '(SELECT SUM(total_amount) FROM `order` WHERE YEAR(created_at) = YEAR(NOW()) AND MONTH(created_at) = MONTH(NOW()) AND status= "finalizado") AS totalMonthOrder'
            ])
                .getRawOne(),
            this.coursePaymentRepository.createQueryBuilder('course_payment')
                .select([
                'SUM(course_payment.amount) AS totalCoursePayment',
                '(SELECT SUM(amount) FROM `course_payment` WHERE YEAR(created_at) = YEAR(NOW()) AND MONTH(created_at) = MONTH(NOW()) AND status = "PAID") AS totalMonthCourse'
            ])
                .getRawOne(),
        ]);
        const recentTransactions = [...recentOrders, ...recentCoursePayments]
            .sort((a, b) => new Date(b.created_at).getTime() - new Date(a.created_at).getTime());
        return {
            recentTransactions,
            totalMonth: Number(totals?.totalMonthOrder ?? 0) + Number(coursePaymentTotals?.totalMonthCourse ?? 0),
            totalEcommerce: Number(totals?.totalEcommerce ?? 0),
            totalEcommerceMonth: Number(totals?.totalMonthOrder ?? 0),
            totalCoursePaymentMonth: Number(coursePaymentTotals?.totalMonthCourse ?? 0),
            totalCoursePayment: Number(coursePaymentTotals?.totalCoursePayment ?? 0),
        };
    }
    findOne(id) {
        return `This action returns a #${id} dashboard`;
    }
    update(id, updateDashboardDto) {
        return `This action updates a #${id} dashboard`;
    }
    remove(id) {
        return `This action removes a #${id} dashboard`;
    }
};
exports.DashboardService = DashboardService;
exports.DashboardService = DashboardService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __param(1, (0, typeorm_1.InjectRepository)(course_payment_entity_1.Course_payment)),
    __param(2, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], DashboardService);
//# sourceMappingURL=dashboard.service.js.map