"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateProductDto = void 0;
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
class CreateProductDto {
    cod_product;
    name;
    description;
    price;
    image;
    line;
    quantity;
    category;
    safety_stock;
    time_to_replacement;
}
exports.CreateProductDto = CreateProductDto;
__decorate([
    (0, class_validator_1.IsString)({
        message: 'O código do produto é obrigatório e deve ser uma string válida',
    }),
    __metadata("design:type", String)
], CreateProductDto.prototype, "cod_product", void 0);
__decorate([
    (0, class_validator_1.IsString)({
        message: 'O nome do produto é obrigatório e deve ser uma string válida',
    }),
    __metadata("design:type", String)
], CreateProductDto.prototype, "name", void 0);
__decorate([
    (0, class_validator_1.IsString)({
        message: 'A descrição do produto é obrigatória e deve ser uma string válida',
    }),
    __metadata("design:type", String)
], CreateProductDto.prototype, "description", void 0);
__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNotEmpty)({ message: 'O preço é obrigatório' }),
    (0, class_validator_1.Min)(1, { message: 'O preço do produto deve ser maior que 0.' }),
    (0, class_validator_1.Max)(100000, { message: 'O preço do produto deve ser menor que R$100.000.' }),
    __metadata("design:type", Number)
], CreateProductDto.prototype, "price", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)({
        message: 'O campo de imagem deve ser uma string (URL ou caminho local).',
    }),
    (0, class_validator_1.MaxLength)(255, {
        message: 'O caminho/URL da imagem deve ter no máximo 255 caracteres.',
    }),
    __metadata("design:type", String)
], CreateProductDto.prototype, "image", void 0);
__decorate([
    (0, class_validator_1.IsString)({ message: 'A linha do produto deve ser uma string válida' }),
    __metadata("design:type", String)
], CreateProductDto.prototype, "line", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'A quantidade é obrigatória' }),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsInt)({ message: 'A quantidade deve ser um número inteiro.' }),
    __metadata("design:type", Number)
], CreateProductDto.prototype, "quantity", void 0);
__decorate([
    (0, class_validator_1.IsString)({ message: 'A categoria do produto deve ser uma string válida' }),
    __metadata("design:type", String)
], CreateProductDto.prototype, "category", void 0);
__decorate([
    (0, class_validator_1.IsInt)({ message: 'O estoque de segurança deve ser um número inteiro.' }),
    (0, class_validator_1.Min)(10, { message: 'O estoque de segurança deve ser no mínimo 10.' }),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNotEmpty)({ message: 'O estoque de segurança é obrigatório' }),
    __metadata("design:type", Number)
], CreateProductDto.prototype, "safety_stock", void 0);
__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsInt)({
        message: 'O tempo para substituição deve ser um número inteiro em horas.',
    }),
    (0, class_validator_1.Min)(1, { message: 'O tempo para substituição deve ser no mínimo 1 hora.' }),
    (0, class_validator_1.Max)(43800, {
        message: 'O tempo para substituição não pode exceder 43.800 horas (5 anos).',
    }),
    __metadata("design:type", Number)
], CreateProductDto.prototype, "time_to_replacement", void 0);
//# sourceMappingURL=create-product.dto.js.map