"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignaturesController = void 0;
const common_2 = require("@nestjs/common");
const signatures_service_1 = require("./signatures.service");
const create_signature_dto_1 = require("./dto/create-signature.dto");
const update_signature_dto_1 = require("./dto/update-signature.dto");
const required_roles_decorator_1 = require("../../shared/auth/required-roles.decorator");
const auth_guard_1 = require("../../shared/auth/auth.guard");
const role_guard_1 = require("../../shared/auth/role/role.guard");
const enum_1 = require("../../shared/enums/enum");
const platform_express_1 = require("@nestjs/platform-express");
const path_1 = require("path");
let SignaturesController = class SignaturesController {
    signaturesService;
    constructor(signaturesService) {
        this.signaturesService = signaturesService;
    }
    async create(createSignatureDto, file) {
        if (file) {
            try {
                const imageUrl = await this.signaturesService.uploadImageToS3(file, file.originalname);
                createSignatureDto.imageUrl = imageUrl;
            }
            catch (error) {
                throw new common_2.BadRequestException('Falha ao enviar imagem para o S3: ' + error);
            }
        }
        return this.signaturesService.create(createSignatureDto);
    }
    findAll() {
        return this.signaturesService.findAll();
    }
    findAllForManagement() {
        return this.signaturesService.findAllForManagement();
    }
    findOne(id) {
        return this.signaturesService.findOne(+id);
    }
    findOneForManagement() {
        return this.signaturesService.findOneForManagement();
    }
    async update(id, updateSignatureDto, file) {
        console.log("FILE CONTROLLER ", file);
        if (file) {
            const ext = (0, path_1.extname)(file.originalname);
            const fileName = `${Date.now()}-${Math.round(Math.random() * 1e9)}${ext}`;
            try {
                const imageUrl = await this.signaturesService.uploadImageToS3(file, fileName);
                updateSignatureDto.imageUrl = imageUrl;
            }
            catch (error) {
                throw new common_2.BadRequestException('Falha ao enviar imagem para o S3: ' + error);
            }
        }
        return this.signaturesService.update(+id, updateSignatureDto);
    }
    remove(id) {
        return this.signaturesService.remove(+id);
    }
};
exports.SignaturesController = SignaturesController;
__decorate([
    (0, common_2.Post)('/registro'),
    (0, common_2.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    __param(0, (0, common_2.Body)()),
    __param(1, (0, common_2.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_signature_dto_1.CreateSignatureDto, Object]),
    __metadata("design:returntype", Promise)
], SignaturesController.prototype, "create", null);
__decorate([
    (0, common_2.Get)('/'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SignaturesController.prototype, "findAll", null);
__decorate([
    (0, common_2.Get)('/restrito'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SignaturesController.prototype, "findAllForManagement", null);
__decorate([
    (0, common_2.Get)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SignaturesController.prototype, "findOne", null);
__decorate([
    (0, common_2.Get)(':id/restrito'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SignaturesController.prototype, "findOneForManagement", null);
__decorate([
    (0, common_2.Patch)(':id'),
    (0, common_2.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Body)()),
    __param(2, (0, common_2.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_signature_dto_1.UpdateSignatureDto, Object]),
    __metadata("design:returntype", Promise)
], SignaturesController.prototype, "update", null);
__decorate([
    (0, common_2.Delete)(':id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SignaturesController.prototype, "remove", null);
exports.SignaturesController = SignaturesController = __decorate([
    (0, common_2.Controller)('signatures'),
    __metadata("design:paramtypes", [signatures_service_1.SignaturesService])
], SignaturesController);
//# sourceMappingURL=signatures.controller.js.map