import { Class } from './entities/class.entity';
import { Repository } from 'typeorm';
import { CreateClassDto } from './dto/create-video.dto';
import { UpdateClassDto } from './dto/upload-video.dto';
export declare class ClassesService {
    private classesRepository;
    constructor(classesRepository: Repository<Class>);
    private s3;
    create(createClassDto: CreateClassDto[]): Promise<Class[]>;
    findAll(): Promise<Class[]>;
    findAllForManagement(): Promise<Class[]>;
    findOneForManagement(): Promise<Class[]>;
    findOne(videoId: number): Promise<Class>;
    uploadImageToS3(file: Express.Multer.File, fileName: string): Promise<string>;
    update(updateClassDto: UpdateClassDto): Promise<{
        success: boolean;
        message: string;
        statusCode: number;
    }>;
    remove(videoId: number): Promise<{
        message: string;
    }>;
    findClassById(classId: number): Promise<Class>;
}
