"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResetPasswordDto = exports.forgotPasswordDto = void 0;
const class_validator_1 = require("class-validator");
class forgotPasswordDto {
    email;
}
exports.forgotPasswordDto = forgotPasswordDto;
__decorate([
    (0, class_validator_1.IsEmail)({}, { message: "O e-mail precisa válido" }),
    (0, class_validator_1.IsNotEmpty)({ message: "O campo e-mail não pode ser vázio" }),
    __metadata("design:type", String)
], forgotPasswordDto.prototype, "email", void 0);
class ResetPasswordDto {
    email;
    newPassword;
    code;
}
exports.ResetPasswordDto = ResetPasswordDto;
__decorate([
    (0, class_validator_1.IsEmail)({}, { message: "O e-mail precisa válido" }),
    (0, class_validator_1.IsNotEmpty)({ message: "O campo e-mail não pode ser vázio" }),
    __metadata("design:type", String)
], ResetPasswordDto.prototype, "email", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'A senha não pode ser vazia.' }),
    (0, class_validator_1.IsStrongPassword)({ minLength: 8, minLowercase: 1, minUppercase: 1, minNumbers: 1, minSymbols: 1 }, { message: 'A senha deve ter no mínimo 8 caracteres, com pelo menos uma letra maiúscula, uma minúscula, um número e um caractere especial.' }),
    __metadata("design:type", String)
], ResetPasswordDto.prototype, "newPassword", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'O código não pode estar vazio' }),
    (0, class_validator_1.Length)(6, 6, { message: 'O código deve ter exatamente 6 caracteres' }),
    (0, class_validator_1.Matches)(/^\d{6}$/, { message: 'O código deve conter apenas números' }),
    __metadata("design:type", String)
], ResetPasswordDto.prototype, "code", void 0);
//# sourceMappingURL=recover-password.dto.js.map