"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgendaService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const agenda_entity_1 = require("./entities/agenda.entity");
const typeorm_2 = require("typeorm");
let AgendaService = class AgendaService {
    agendaRepository;
    constructor(agendaRepository) {
        this.agendaRepository = agendaRepository;
    }
    async create(createAgendaDto) {
        const novoAgendamendo = await this.agendaRepository.create(createAgendaDto);
        return await this.agendaRepository.save(novoAgendamendo);
    }
    findAll() {
        return this.agendaRepository.find();
    }
    async findOne(id) {
        const exist = await this.agendaRepository.findOne({
            where: { id },
        });
        if (!exist) {
            throw new common_2.BadRequestException('agenda não existe');
        }
        return exist;
    }
    async update(id, updateAgendaDto) {
        const exist = await this.agendaRepository.findOne({
            where: { id },
        });
        if (!exist) {
            throw new common_2.BadRequestException('agenda não existe');
        }
        return await this.agendaRepository.update({ id }, { ...updateAgendaDto });
    }
    async remove(id) {
        const exist = await this.agendaRepository.findOne({
            where: { id },
        });
        if (!exist) {
            throw new common_2.BadRequestException('agenda não existe');
        }
        return await this.agendaRepository.delete({ id });
    }
};
exports.AgendaService = AgendaService;
exports.AgendaService = AgendaService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(agenda_entity_1.Agenda)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], AgendaService);
//# sourceMappingURL=agenda.service.js.map