"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EquipamentsModule = void 0;
const common_2 = require("@nestjs/common");
const equipaments_service_1 = require("./equipaments.service");
const equipaments_controller_1 = require("./equipaments.controller");
const equipament_entity_1 = require("./entities/equipament.entity");
const door_entity_1 = require("../doors/entities/door.entity");
const industrial_fan_entity_1 = require("../industrial_fans/entities/industrial_fan.entity");
const typeorm_1 = require("@nestjs/typeorm");
const jwt_1 = require("@nestjs/jwt");
const doors_module_1 = require("../doors/doors.module");
const industrial_fans_module_1 = require("../industrial_fans/industrial_fans.module");
const equipaments_gateway_1 = require("./equipaments.gateway");
const user_entity_1 = require("../../shared/users/entities/user.entity");
const model_entity_1 = require("../models/entities/model.entity");
const watcher_entity_1 = require("../watchers/entities/watcher.entity");
const schedules_entity_1 = require("./entities/schedules.entity");
const group_entity_1 = require("../group/entities/group.entity");
let EquipamentsModule = class EquipamentsModule {
};
exports.EquipamentsModule = EquipamentsModule;
exports.EquipamentsModule = EquipamentsModule = __decorate([
    (0, common_2.Module)({
        imports: [typeorm_1.TypeOrmModule.forFeature([equipament_entity_1.Equipament, door_entity_1.Door, industrial_fan_entity_1.IndustrialFan, user_entity_1.User, model_entity_1.Model, watcher_entity_1.Watcher, schedules_entity_1.Schedules, group_entity_1.Group]),
            jwt_1.JwtModule.register({
                secret: process.env.JWT_SECRET || 'secret',
            }),
            doors_module_1.DoorsModule,
            industrial_fans_module_1.IndustrialFansModule,
        ],
        controllers: [equipaments_controller_1.EquipamentsController],
        providers: [equipaments_service_1.EquipamentsService, equipaments_gateway_1.EquipamentsGateway],
        exports: [equipaments_service_1.EquipamentsService]
    })
], EquipamentsModule);
//# sourceMappingURL=equipaments.module.js.map