import { Response } from 'express';
import { FilesService } from './files.service';
import { CreateFolderDto } from './dto/create-path.dto';
import { UpdatePathDto } from './dto/update-path.dto';
export declare class FilesController {
    private readonly filesService;
    constructor(filesService: FilesService);
    create(file: Express.Multer.File, data: string): Promise<string>;
    createFolder(createFolderDto: CreateFolderDto): Promise<import("./entities/path.entity").Folder>;
    getRaiz(currentUser: any): Promise<import("./entities/path.entity").Folder[]>;
    getRelation(id: number, currentUser: any): Promise<{
        children: import("./entities/path.entity").Folder[];
        files: {
            fileData: {
                id: number;
                file_name: string;
                name: string;
                version: string;
                description: string;
                type: string;
                size: number;
                folder: import("./entities/path.entity").Folder;
                created_on: Date;
            };
        }[];
    }>;
    editPath(id: number, updateFolderDto: UpdatePathDto): Promise<{
        oldPath: string;
        newPath: string;
    }>;
    delete(id: number): Promise<void>;
    downloadFile(id: number, res: Response): Promise<void>;
    viewImage(id: number, res: Response): Promise<void>;
    findAll(): Promise<import("./entities/files.entity").Files[]>;
    remove(id: string): Promise<boolean>;
}
