import { PostService } from './post.service';
import { UpdatePostDto } from './dto/update-post.dto';
import { User } from 'src/shared/users/entities/user.entity';
import { CreateComentarioDto } from './dto/create-comentario.dto';
export declare class PostController {
    private readonly postService;
    constructor(postService: PostService);
    create(data: string, imagemUrl: Express.Multer.File, currentUser: User): Promise<import("./entities/post.entity").Post>;
    createComentario(createComentarioDto: CreateComentarioDto, currentUser: User, postId: string): Promise<import("./entities/comentario.entity").Comentario>;
    findAll(currentUser: User): Promise<import("./entities/post.entity").Post[] | {
        posts: import("./entities/post.entity").Post[];
        course: any[];
        courseProgress: any[];
        agendamentos: import("../agenda/entities/agenda.entity").Agenda[];
    }>;
    getComentarios(id: string): Promise<any[]>;
    findOne(id: string, currentUser: User): Promise<{
        comentarios: any[];
        interacaoPost: any[];
        id: number;
        titulo: String;
        subtitulo: String;
        corpo: String;
        data: Date;
        views: number;
        like: number;
        deslike: number;
        url: string;
        categoria: string;
        tipo: string;
        user: User;
        comentario: import("./entities/comentario.entity").Comentario[];
        postInteration: import("./entities/postInteration.entity").PostInteration[];
    } | null>;
    like(id: string, currentUser: User): Promise<string>;
    deslike(id: string, currentUser: User): Promise<string>;
    update(id: string, updatePostDto: UpdatePostDto): Promise<import("typeorm").UpdateResult>;
    remove(id: string): Promise<import("typeorm").DeleteResult>;
    removeComentario(idComentario: string): Promise<import("typeorm").DeleteResult>;
}
