import { CreateSubscriptionPlanDto } from './dto/create-subscription_plan.dto';
import { UpdateSubscriptionPlanDto } from './dto/update-subscription_plan.dto';
import { SubscriptionPlan } from './entities/subscription_plan.entity';
import { Repository } from 'typeorm';
import { SubscriptionPlanUser } from './entities/subscription_plan_user.entity';
import { CreateSubscriptionPlanDtoUser } from './dto/create-subscription_plan_user.dto';
import { User } from 'src/shared/users/entities/user.entity';
export declare class SubscriptionPlanService {
    private subscriptionPlanRepository;
    private subscriptionPlanUserRepository;
    private userRepository;
    constructor(subscriptionPlanRepository: Repository<SubscriptionPlan>, subscriptionPlanUserRepository: Repository<SubscriptionPlanUser>, userRepository: Repository<User>);
    create(createSubscriptionPlanDto: CreateSubscriptionPlanDto): Promise<SubscriptionPlan>;
    addUserToSubscriptionPlan(createSubscriptionPlanDtoUser: CreateSubscriptionPlanDtoUser): Promise<string>;
    findAllUsersWhithPlan(): Promise<{
        userswhithplan: any[];
        othersInfo: {
            totalActive: number;
            totalRevenue: any;
            newUserThisMonth: number;
        };
    }>;
    findOneUserWhithPlan(id: number): Promise<any>;
    findAll(): Promise<SubscriptionPlan[]>;
    update(id: number, updateSubscriptionPlanDto: UpdateSubscriptionPlanDto): string;
    remove(id: number): string;
}
