"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WatchersController = void 0;
const common_2 = require("@nestjs/common");
const watchers_service_1 = require("./watchers.service");
const create_watcher_dto_1 = require("./dto/create-watcher.dto");
const permissions_guards_1 = require("../../shared/auth/permissions.guards");
const auth_guard_1 = require("../../shared/auth/auth.guard");
let WatchersController = class WatchersController {
    watchersService;
    constructor(watchersService) {
        this.watchersService = watchersService;
    }
    create(id, createWatcherDto) {
        return this.watchersService.create(+id, createWatcherDto);
    }
    findAllByOwner(id) {
        return this.watchersService.findAllByOwner(+id);
    }
    findAllByWatcher(id) {
        return this.watchersService.findAllByWatcher(+id);
    }
    remove(id, watcherId) {
        return this.watchersService.remove(+id, +watcherId);
    }
};
exports.WatchersController = WatchersController;
__decorate([
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    (0, common_2.Post)('/registro/:id'),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, create_watcher_dto_1.CreateWatcherDto]),
    __metadata("design:returntype", void 0)
], WatchersController.prototype, "create", null);
__decorate([
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    (0, common_2.Get)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WatchersController.prototype, "findAllByOwner", null);
__decorate([
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    (0, common_2.Get)('/minhas-observacoes/:id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WatchersController.prototype, "findAllByWatcher", null);
__decorate([
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    (0, common_2.Delete)(':id/remove/:watcherId'),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Param)('watcherId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], WatchersController.prototype, "remove", null);
exports.WatchersController = WatchersController = __decorate([
    (0, common_2.Controller)('observadores'),
    __metadata("design:paramtypes", [watchers_service_1.WatchersService])
], WatchersController);
//# sourceMappingURL=watchers.controller.js.map