"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsaasGateway = void 0;
const websockets_1 = require("@nestjs/websockets");
const socket_io_1 = require("socket.io");
let AsaasGateway = class AsaasGateway {
    server;
    handleRoomJoin(client, data) {
        client.join(data.customerId);
        console.log(`Socket ${client.id} entrou na sala do cliente: ${data.customerId}`);
        client.emit('room_joined', { rooms: [data.customerId].filter(Boolean) });
    }
    async sendConfirmedPayment(paymentId, customerId, status) {
        const sockets = await this.server.in(customerId).fetchSockets();
        if (sockets.length === 0) {
            console.warn(`Nenhum socket conectado à sala ${customerId}`);
        }
        else {
            console.log(`Emitindo para sala do cliente ${customerId}:`, sockets.map(s => s.id));
            this.server.to(customerId).emit('pagamento_confirmado', {
                success: true
            });
        }
    }
    async notifyStoreNewOrder(storeId) {
        const sockets = await this.server.in(storeId).fetchSockets();
        if (sockets.length === 0) {
            console.warn(`Nenhum socket conectado à sala da loja ${storeId}`);
        }
        else {
            console.log(`Notificando loja ${storeId} com sockets:`, sockets.map(s => s.id));
            this.server.to(storeId).emit('pagamento_confirmado', {
                success: true
            });
        }
    }
};
exports.AsaasGateway = AsaasGateway;
__decorate([
    (0, websockets_1.WebSocketServer)(),
    __metadata("design:type", socket_io_1.Server)
], AsaasGateway.prototype, "server", void 0);
__decorate([
    (0, websockets_1.SubscribeMessage)('notificacao-pagamento'),
    __param(0, (0, websockets_1.ConnectedSocket)()),
    __param(1, (0, websockets_1.MessageBody)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [socket_io_1.Socket, Object]),
    __metadata("design:returntype", void 0)
], AsaasGateway.prototype, "handleRoomJoin", null);
exports.AsaasGateway = AsaasGateway = __decorate([
    (0, websockets_1.WebSocketGateway)({
        cors: {
            origin: '*',
        },
    })
], AsaasGateway);
//# sourceMappingURL=asaas.gateway.js.map