import { HttpService } from '@nestjs/axios';
import { EventEmitter2 } from '@nestjs/event-emitter';
import { User } from 'src/shared/users/entities/user.entity';
import { Repository } from 'typeorm';
import { CreateChargeDto, CreateCreditChargeDto } from './dto/create-asaas-dto';
import { Order } from '../orders/entities/order.entity';
import { OrdersService } from '../orders/orders.service';
import { Course_payment } from '../course_payment/entities/course_payment.entity';
import { Creditcard } from '../creditcard/entities/creditcard.entity';
export declare class AsaasService {
    private readonly http;
    private readonly eventEmitter;
    private readonly ordersService;
    private readonly userRepository;
    private readonly creditcardRepository;
    private readonly orderRepositoty;
    private readonly course_paymentRepository;
    private readonly baseURL;
    private readonly headers;
    constructor(http: HttpService, eventEmitter: EventEmitter2, ordersService: OrdersService, userRepository: Repository<User>, creditcardRepository: Repository<Creditcard>, orderRepositoty: Repository<Order>, course_paymentRepository: Repository<Course_payment>);
    handlePaymentWebhook(payload: any): Promise<void>;
    createPixCharge(createChargeDto: CreateChargeDto): Promise<{
        paymentId: string;
        qrCode: string;
        copyPaste: string;
    }>;
    createPixChargeForCourse(createChargeDto: CreateChargeDto): Promise<{
        paymentId: string;
        qrCode: string;
        copyPaste: string;
    }>;
    createCreditCardPayment(createChargeDto: CreateCreditChargeDto): Promise<{
        paymentId: any;
    }>;
    createCreditCardPaymentCourse(CreateCreditChargeDto: CreateCreditChargeDto): Promise<{
        paymentId: any;
    }>;
    private getOrCreateCustomer;
    getPixQrCode(paymentId: string): Promise<any>;
    fakePayment(userId: number, orderId: number): Promise<{
        message: string;
    }>;
    createSubscription(userId: any): Promise<any>;
    paySubscription(userId: any): Promise<any>;
    getUserSubscriptions(userId: any): Promise<any>;
}
