"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CourseModule = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const jwt_1 = require("@nestjs/jwt");
const courses_controller_1 = require("./courses.controller");
const courses_service_1 = require("./courses.service");
const courses_entity_1 = require("./entites/courses.entity");
const class_entity_1 = require("../videos/entities/class.entity");
const user_entity_1 = require("../../shared/users/entities/user.entity");
const course_payment_entity_1 = require("../course_payment/entities/course_payment.entity");
const course_lesson_progress_entity_1 = require("./entites/course_lesson_progress.entity");
let CourseModule = class CourseModule {
};
exports.CourseModule = CourseModule;
exports.CourseModule = CourseModule = __decorate([
    (0, common_2.Module)({
        imports: [typeorm_1.TypeOrmModule.forFeature([courses_entity_1.Course, class_entity_1.Class, user_entity_1.User, course_payment_entity_1.Course_payment, course_lesson_progress_entity_1.CourseLessonProgress]),
            jwt_1.JwtModule.register({
                secret: process.env.JWT_SECRET || 'secret',
            }),
        ],
        controllers: [courses_controller_1.CourseController],
        providers: [courses_service_1.CourseService],
        exports: [courses_service_1.CourseService]
    })
], CourseModule);
//# sourceMappingURL=courses.module.js.map