"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FreteInfoService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const frete_info_entity_1 = require("./entities/frete_info.entity");
const user_entity_1 = require("../../shared/users/entities/user.entity");
let FreteInfoService = class FreteInfoService {
    freteInfoRepository;
    userRepository;
    constructor(freteInfoRepository, userRepository) {
        this.freteInfoRepository = freteInfoRepository;
        this.userRepository = userRepository;
    }
    async create(createFreteInfoDto, currentUser) {
        const existingFreteInfo = await this.freteInfoRepository.findOne({
            where: { user: { id: currentUser.id } },
        });
        if (existingFreteInfo) {
            this.freteInfoRepository.merge(existingFreteInfo, createFreteInfoDto);
            await this.freteInfoRepository.save(existingFreteInfo);
            return 'Endereço atualizado com sucesso!';
        }
        else {
            const freteInfo = this.freteInfoRepository.create({
                ...createFreteInfoDto,
                user: { id: currentUser.id },
            });
            await this.freteInfoRepository.save(freteInfo);
            return 'Endereço cadastrado com sucesso!';
        }
    }
    async findOne(currentUser) {
        if (!currentUser || !currentUser.id) {
            throw new common_2.BadRequestException('Usuário não autenticado ou inválido.');
        }
        const userExist = await this.freteInfoRepository.findOne({
            where: { user: { id: currentUser.id } }
        });
        if (!userExist) {
            throw new common_2.BadRequestException('Endereço não encontrado');
        }
        return userExist;
    }
    update(CurrentUser, id, updateFreteInfoDto) {
        const userExist = this.freteInfoRepository.findOne({
            where: { user: { id: CurrentUser.id } }
        });
        if (!userExist) {
            throw new common_2.BadRequestException('Endereço não encontrado');
        }
        const update = this.freteInfoRepository.update(id, updateFreteInfoDto);
        return update;
    }
};
exports.FreteInfoService = FreteInfoService;
exports.FreteInfoService = FreteInfoService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(frete_info_entity_1.FreteInfo)),
    __param(1, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], FreteInfoService);
//# sourceMappingURL=frete_info.service.js.map