"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductsController = void 0;
const common_2 = require("@nestjs/common");
const products_service_1 = require("./products.service");
const create_product_dto_1 = require("./dto/create-product.dto");
const update_product_dto_1 = require("./dto/update-product.dto");
const required_roles_decorator_1 = require("../../shared/auth/required-roles.decorator");
const auth_guard_1 = require("../../shared/auth/auth.guard");
const role_guard_1 = require("../../shared/auth/role/role.guard");
const enum_1 = require("../../shared/enums/enum");
const platform_express_1 = require("@nestjs/platform-express");
let ProductsController = class ProductsController {
    productsService;
    constructor(productsService) {
        this.productsService = productsService;
    }
    async create(createProductDto, images) {
        let s3Url = null;
        if (images && images.length > 0) {
            const mainImage = images[0];
            s3Url = await this.productsService.uploadImageToS3(mainImage, mainImage.originalname);
        }
        createProductDto.image = s3Url ?? undefined;
        return this.productsService.create(createProductDto);
    }
    findAll() {
        return this.productsService.findAll();
    }
    findAllForManagement() {
        return this.productsService.findAllForManagement();
    }
    findOne(id) {
        return this.productsService.findOne(+id);
    }
    findOneForManagement() {
        return this.productsService.findOneForManagement();
    }
    async update(id, updateProductDto, file) {
        (file) ? updateProductDto.image = await this.productsService.uploadImageToS3(file, file.originalname) : null;
        return this.productsService.update(+id, updateProductDto);
    }
    remove(id) {
        return this.productsService.remove(+id);
    }
};
exports.ProductsController = ProductsController;
__decorate([
    (0, common_2.Post)('/registro'),
    (0, common_2.UseInterceptors)((0, platform_express_1.FilesInterceptor)('image')),
    __param(0, (0, common_2.Body)()),
    __param(1, (0, common_2.UploadedFiles)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_product_dto_1.CreateProductDto, Array]),
    __metadata("design:returntype", Promise)
], ProductsController.prototype, "create", null);
__decorate([
    (0, common_2.Get)('/'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ProductsController.prototype, "findAll", null);
__decorate([
    (0, common_2.Get)('/restrito'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ProductsController.prototype, "findAllForManagement", null);
__decorate([
    (0, common_2.Get)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ProductsController.prototype, "findOne", null);
__decorate([
    (0, common_2.Get)(':id/restrito'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ProductsController.prototype, "findOneForManagement", null);
__decorate([
    (0, common_2.Patch)(':id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    (0, common_2.UseInterceptors)((0, platform_express_1.FileInterceptor)('image')),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Body)()),
    __param(2, (0, common_2.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_product_dto_1.UpdateProductDto, Object]),
    __metadata("design:returntype", Promise)
], ProductsController.prototype, "update", null);
__decorate([
    (0, common_2.Delete)(':id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ProductsController.prototype, "remove", null);
exports.ProductsController = ProductsController = __decorate([
    (0, common_2.Controller)('produtos'),
    __metadata("design:paramtypes", [products_service_1.ProductsService])
], ProductsController);
//# sourceMappingURL=products.controller.js.map