"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShoppingCartService = void 0;
const common_2 = require("@nestjs/common");
const order_entity_1 = require("../orders/entities/order.entity");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const enum_1 = require("../../shared/enums/enum");
const users_service_1 = require("../../shared/users/users.service");
const order_transaction_entity_1 = require("../orders/entities/order_transaction.entity");
const products_service_1 = require("../products/products.service");
const order_product_entity_1 = require("../orders/entities/order_product.entity");
const cupom_entity_1 = require("../cupom/entities/cupom.entity");
let ShoppingCartService = class ShoppingCartService {
    shoppingCartRepository;
    orderTransactionRepository;
    orderProductRepository;
    cupomRepository;
    usersService;
    productsService;
    constructor(shoppingCartRepository, orderTransactionRepository, orderProductRepository, cupomRepository, usersService, productsService) {
        this.shoppingCartRepository = shoppingCartRepository;
        this.orderTransactionRepository = orderTransactionRepository;
        this.orderProductRepository = orderProductRepository;
        this.cupomRepository = cupomRepository;
        this.usersService = usersService;
        this.productsService = productsService;
    }
    async addItemFromCart(currentUser, addItemFromCartDto) {
        const product = await this.productsService.findProductById(addItemFromCartDto.productId);
        const cart = await this.getOrCreateShoppingCart(currentUser.id);
        const orderTransactionExist = await this.orderTransactionRepository.findOne({
            where: {
                order: { id: cart.id },
            }
        });
        if (orderTransactionExist && (orderTransactionExist.status === enum_1.Status.PENDING_PAYMENT || orderTransactionExist.status === enum_1.Status.PAID)) {
            throw new common_2.BadRequestException("Ops você ainda tem pedido em andamento");
        }
        const orderItemExist = await this.orderProductRepository.findOne({
            where: {
                order: { id: cart.id },
                product: product,
            },
        });
        if (product.quantity < addItemFromCartDto.quantity) {
            throw new common_2.BadRequestException(`Quantidade do produto solicitado está indisponível. Apenas ${product.quantity} disponíveis no momento. Quantidade solicitada ${addItemFromCartDto.quantity}`);
        }
        if (orderItemExist) {
            Object.assign(orderItemExist, (orderItemExist.quantity += addItemFromCartDto.quantity));
            if (product.quantity < orderItemExist.quantity) {
                throw new common_2.BadRequestException(`Quantidade do produto solicitado está indisponível. Apenas ${product.quantity} disponíveis no momento. Quantidade solicitada ${addItemFromCartDto.quantity}`);
            }
            await this.orderProductRepository.save(orderItemExist);
        }
        else {
            await this.orderProductRepository.save(this.orderProductRepository.create({
                order: cart,
                product,
                quantity: addItemFromCartDto.quantity,
                unit_price: product.price,
            }));
        }
        await this._recalculateCartTotalsAndUpdateStoreId(cart.id);
        return { message: "Produto adicionado ao carrinho" };
    }
    async getCartContents(currentUser) {
        const cart = await this.shoppingCartRepository.findOne({
            where: {
                user: { id: currentUser.id },
                status: (0, typeorm_2.In)([enum_1.Status.OPEN, enum_1.Status.PENDING_PAYMENT, enum_1.Status.PAID]),
            },
            relations: ['cupom']
        });
        if (!cart) {
            return { message: 'Seu carrinho está vazio' };
        }
        const itemsOnCart = await this.orderProductRepository.find({
            where: { order: { id: cart.id } },
            relations: ['product'],
        });
        const subtotal = itemsOnCart.reduce((sum, item) => {
            return sum + (Number(item.product.price) * item.quantity);
        }, 0);
        let finalAmount = subtotal;
        let discountVal = 0;
        if (cart.cupom) {
            const percentage = Number(cart.cupom.desconto);
            if (!isNaN(percentage) && percentage > 0) {
                discountVal = (subtotal * percentage) / 100;
                finalAmount = subtotal - discountVal;
            }
        }
        if (Number(cart.total_amount) !== finalAmount) {
            cart.total_amount = finalAmount;
            await this.shoppingCartRepository.save(cart);
            console.log(`Valor atualizado no banco: De ${subtotal} para ${finalAmount}`);
        }
        const formattedItems = itemsOnCart.map((item) => ({
            id: item.product.id,
            name: item.product.name,
            description: item.product.description,
            image: item.product.image,
            quantity: item.quantity,
            price: item.product.price,
            quantity_in_stock: item.product.quantity,
        }));
        return {
            order: {
                id: cart.id,
                status: cart.status,
                total_items: cart.total_items,
                cupom: cart.cupom,
                subtotal: subtotal,
                total_amount: finalAmount,
                discount_applied: discountVal,
                items: formattedItems,
            },
        };
    }
    async countTotalItemsInOpenOrder(currentUser) {
        const user = await this.usersService.findUserById(currentUser.id);
        const cart = await this.findOpenOrderByUser(user.id);
        let totalItems;
        if (!cart || !cart.order_product) {
            totalItems = 0;
        }
        else {
            totalItems = cart.order_product.reduce((total, item) => total + item.quantity, 0);
        }
        return { total_quantity: totalItems };
    }
    async updateItemQuantityInCart(currentUser, updateShoppingCartDto) {
        const product = await this.productsService.findProductById(updateShoppingCartDto.productId);
        const cart = await this.getOrCreateShoppingCart(currentUser.id);
        const orderItemExist = await this.orderProductRepository.findOne({
            where: {
                order: { id: cart.id },
                product: { id: product.id }
            }
        });
        if (!orderItemExist) {
            throw new common_2.NotFoundException("Ops. Não foi possível localizar o produto no carrinho");
        }
        Object.assign(orderItemExist, orderItemExist.quantity = updateShoppingCartDto.quantity);
        await this.orderProductRepository.save(orderItemExist);
        await this._recalculateCartTotalsAndUpdateStoreId(cart.id);
        return { message: "Quantidade atualizada com sucesso" };
    }
    async removeItemFromCart(currentUser, removeItemFromCartDto) {
        const product = await this.productsService.findProductById(removeItemFromCartDto.productId);
        const cart = await this.getOrCreateShoppingCart(currentUser.id);
        const orderItemExist = await this.orderProductRepository.findOne({
            where: {
                order: { id: cart.id },
                product: { id: product.id },
            }
        });
        console.log(cart.id);
        console.log(product);
        console.log(orderItemExist);
        if (!orderItemExist) {
            throw new common_2.NotFoundException("Ops. Não foi possível localizar o produto no carrinho");
        }
        await this.orderProductRepository.remove(orderItemExist);
        await this._recalculateCartTotalsAndUpdateStoreId(cart.id);
        return { message: "Produto removido do carrinho" };
    }
    async getOrCreateShoppingCart(userId) {
        await this.usersService.findUserById(userId);
        let cart = await this.findOpenOrderByUser(userId);
        if (!cart) {
            const newCart = await this.shoppingCartRepository.save(this.shoppingCartRepository.create({ user: { id: userId } }));
            await this.orderTransactionRepository.save(this.orderTransactionRepository.create({
                order: newCart,
                status: enum_1.Status.OPEN
            }));
            cart = newCart;
        }
        return cart;
    }
    async findOpenOrderByUser(userId) {
        return await this.shoppingCartRepository.findOne({
            where: {
                user: { id: userId },
                status: enum_1.Status.OPEN,
            },
            relations: ['order_product']
        });
    }
    async _recalculateCartTotalsAndUpdateStoreId(cartId) {
        const cart = await this.shoppingCartRepository.findOneBy({ id: cartId });
        if (!cart) {
            console.error(`Tentativa de recalcular totais para o carrinho ID ${cartId}, que não foi encontrado.`);
            return;
        }
        const totals = await this.orderProductRepository
            .createQueryBuilder('orderProduct')
            .innerJoin('orderProduct.product', 'product')
            .select('SUM(orderProduct.quantity)', 'total_items')
            .addSelect('SUM(orderProduct.quantity * orderProduct.unit_price)', 'sub_total')
            .where('orderProduct.orderId = :cartId', { cartId })
            .getRawOne();
        await this.shoppingCartRepository.update(cartId, {
            total_items: Number(totals.total_items) || 0,
            total_amount: totals.sub_total || 0,
        });
    }
};
exports.ShoppingCartService = ShoppingCartService;
exports.ShoppingCartService = ShoppingCartService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __param(1, (0, typeorm_1.InjectRepository)(order_transaction_entity_1.OrderTransactions)),
    __param(2, (0, typeorm_1.InjectRepository)(order_product_entity_1.OrderProduct)),
    __param(3, (0, typeorm_1.InjectRepository)(cupom_entity_1.Cupom)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        users_service_1.UsersService,
        products_service_1.ProductsService])
], ShoppingCartService);
//# sourceMappingURL=shopping_cart.service.js.map