"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClassesController = void 0;
const common_2 = require("@nestjs/common");
const classes_service_1 = require("./classes.service");
const upload_video_dto_1 = require("./dto/upload-video.dto");
const required_roles_decorator_1 = require("../../shared/auth/required-roles.decorator");
const auth_guard_1 = require("../../shared/auth/auth.guard");
const role_guard_1 = require("../../shared/auth/role/role.guard");
const enum_1 = require("../../shared/enums/enum");
const platform_express_1 = require("@nestjs/platform-express");
const path_1 = require("path");
let ClassesController = class ClassesController {
    classService;
    constructor(classService) {
        this.classService = classService;
    }
    async createMany(body, files) {
        let createClassDtoArray;
        if (body.data && typeof body.data === 'string') {
            try {
                createClassDtoArray = JSON.parse(body.data);
            }
            catch (e) {
                throw new common_2.BadRequestException('O JSON enviado no campo "data" é inválido.');
            }
        }
        else {
            createClassDtoArray = body;
        }
        if (!Array.isArray(createClassDtoArray)) {
            createClassDtoArray = [createClassDtoArray];
        }
        console.log("Array processado: ", createClassDtoArray);
        if (files && files.length > 0) {
            for (let i = 0; i < createClassDtoArray.length; i++) {
                if (files[i]) {
                    const file = files[i];
                    const videoUrl = await this.classService.uploadImageToS3(file, file.originalname);
                    createClassDtoArray[i].url = videoUrl;
                }
            }
        }
        return this.classService.create(createClassDtoArray);
    }
    findAll() {
        return this.classService.findAll();
    }
    findAllForManagement() {
        return this.classService.findAllForManagement();
    }
    findOne(id) {
        return this.classService.findOne(+id);
    }
    findOneForManagement() {
        return this.classService.findOneForManagement();
    }
    async update(updateClassDto, file) {
        console.log("FILE CONTROLLER ", file);
        console.log("DTO CONTROLLER ", updateClassDto);
        if (file) {
            const ext = (0, path_1.extname)(file.originalname);
            const fileName = `${Date.now()}-${Math.round(Math.random() * 1e9)}${ext}`;
            try {
                const videoUrl = await this.classService.uploadImageToS3(file, fileName);
                updateClassDto.url = videoUrl;
            }
            catch (error) {
                throw new common_2.BadRequestException('Falha ao enviar imagem para o S3: ' + error);
            }
        }
        return this.classService.update(updateClassDto);
    }
    remove(id) {
        return this.classService.remove(+id);
    }
};
exports.ClassesController = ClassesController;
__decorate([
    (0, common_2.Post)('/registro'),
    (0, common_2.UseInterceptors)((0, platform_express_1.FilesInterceptor)('files')),
    __param(0, (0, common_2.Body)()),
    __param(1, (0, common_2.UploadedFiles)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Array]),
    __metadata("design:returntype", Promise)
], ClassesController.prototype, "createMany", null);
__decorate([
    (0, common_2.Get)('/'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ClassesController.prototype, "findAll", null);
__decorate([
    (0, common_2.Get)('/restrito'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ClassesController.prototype, "findAllForManagement", null);
__decorate([
    (0, common_2.Get)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ClassesController.prototype, "findOne", null);
__decorate([
    (0, common_2.Get)(':id/restrito'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ClassesController.prototype, "findOneForManagement", null);
__decorate([
    (0, common_2.Patch)('editar'),
    (0, common_2.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    __param(0, (0, common_2.Body)()),
    __param(1, (0, common_2.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [upload_video_dto_1.UpdateClassDto, Object]),
    __metadata("design:returntype", Promise)
], ClassesController.prototype, "update", null);
__decorate([
    (0, common_2.Delete)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ClassesController.prototype, "remove", null);
exports.ClassesController = ClassesController = __decorate([
    (0, common_2.Controller)('video'),
    __metadata("design:paramtypes", [classes_service_1.ClassesService])
], ClassesController);
//# sourceMappingURL=classes.controller.js.map