"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("dotenv/config");
const core_1 = require("@nestjs/core");
const app_module_1 = require("./app.module");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const fs = require("fs");
const morgan = require("morgan");
const HTTPS_PORT = process.env.HTTPS_PORT;
const HTTP_PORT = process.env.HTTP_PORT;
function getValidationPipe() {
    return new common_1.ValidationPipe({
        transform: true,
        whitelist: false,
        forbidNonWhitelisted: false,
        exceptionFactory: (errors) => {
            const messages = errors.flatMap(error => Object.values(error.constraints || {}));
            return new common_1.BadRequestException({ message: messages });
        },
    });
}
async function setupApp(app) {
    app.use(morgan('dev'));
    app.useGlobalPipes(getValidationPipe());
    const config = new swagger_1.DocumentBuilder()
        .setTitle('Visoflex-API')
        .setDescription('Documentação da API')
        .setVersion('1.0')
        .addBearerAuth()
        .build();
    const document = swagger_1.SwaggerModule.createDocument(app, config);
    swagger_1.SwaggerModule.setup('api', app, document);
}
async function bootstrap() {
    const isProduction = process.env.ENVIRONMENT === "production";
    if (isProduction) {
        const httpsOptions = {
            key: fs.readFileSync('/home/viso360/ssl/keys/a17d5_6f92b_ecbf36f6f14d72295d7bce6edac45334.key'),
            cert: fs.readFileSync('/home/viso360/ssl/certs/api_viso360_com_br_a17d5_6f92b_1772650672_0c704673119fad5540769e41a0e50136.crt'),
        };
        const appHttps = await core_1.NestFactory.create(app_module_1.AppModule, {
            cors: true,
            httpsOptions,
        });
        await setupApp(appHttps);
        await appHttps.listen(HTTPS_PORT ?? 3337);
        console.log('✅ HTTPS rodando na porta 3337');
        const appHttp = await core_1.NestFactory.create(app_module_1.AppModule, {
            cors: true,
        });
        await setupApp(appHttp);
        await appHttp.listen(HTTP_PORT ?? 3310);
        console.log('🌐 HTTP rodando na porta 3310');
    }
    else {
        const app = await core_1.NestFactory.create(app_module_1.AppModule, {
            cors: true,
        });
        await setupApp(app);
        const port = Number(HTTPS_PORT ?? 3337);
        await app.listen(port);
        console.log(`🧪 Dev rodando em http://localhost:${port}`);
    }
}
bootstrap();
//# sourceMappingURL=main.js.map