"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppGateway = void 0;
const enum_1 = require("../enums/enum");
const jwt_1 = require("@nestjs/jwt");
const websockets_1 = require("@nestjs/websockets");
const socket_io_1 = require("socket.io");
const equipaments_service_1 = require("../../visoflex360/equipaments/equipaments.service");
let AppGateway = class AppGateway {
    jwtService;
    equipamentService;
    server;
    constructor(jwtService, equipamentService) {
        this.jwtService = jwtService;
        this.equipamentService = equipamentService;
    }
    handleConnection(socket) {
        const token = socket.handshake.auth?.token;
        if (!token) {
            socket.disconnect(true);
            return;
        }
        try {
            const payload = this.jwtService.verify(token);
            if (payload.roles === enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN) {
                socket.join('admin');
            }
            else {
                const userId = payload.id;
                socket.join(`user-${userId}`);
                this.equipamentService.updateUserCards(userId);
            }
        }
        catch (err) {
            socket.disconnect();
        }
    }
};
exports.AppGateway = AppGateway;
__decorate([
    (0, websockets_1.WebSocketServer)(),
    __metadata("design:type", socket_io_1.Server)
], AppGateway.prototype, "server", void 0);
exports.AppGateway = AppGateway = __decorate([
    (0, websockets_1.WebSocketGateway)(),
    __metadata("design:paramtypes", [jwt_1.JwtService,
        equipaments_service_1.EquipamentsService])
], AppGateway);
//# sourceMappingURL=handshake.auth.js.map