"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermissionsGuard = void 0;
const common_2 = require("@nestjs/common");
let PermissionsGuard = class PermissionsGuard {
    canActivate(context) {
        const request = context.switchToHttp().getRequest();
        const user = request.user;
        if (user.roles.indexOf('admin') > -1) {
            return true;
        }
        if (user.roles.indexOf('user') > -1) {
            const resourceOwnerId = request.params.id;
            if (user.id != Number(resourceOwnerId)) {
                throw new common_2.ForbiddenException('Você não tem permissão para acessar este recurso');
            }
            return true;
        }
        return false;
    }
};
exports.PermissionsGuard = PermissionsGuard;
exports.PermissionsGuard = PermissionsGuard = __decorate([
    (0, common_2.Injectable)()
], PermissionsGuard);
//# sourceMappingURL=permissions.guards.js.map