import { UsersService } from './users.service';
import { CreateUserDto } from './dto/create-user.dto';
import { UpdateUserDto, UpdateUserPasswordDto } from './dto/update-user.dto';
import { Roles } from '../enums/enum';
import { forgotPasswordDto, ResetPasswordDto } from './dto/recover-password.dto';
export declare class UsersController {
    private readonly usersService;
    constructor(usersService: UsersService);
    create(createUserDto: CreateUserDto): Promise<{
        access_token: string;
    } | {
        message: string[];
    }>;
    forgotPassword(forgotPasswordDto: forgotPasswordDto): Promise<{
        message: string;
    }>;
    findUserWithoutRestricData(currentUser: any): Promise<import("./entities/user.entity").User>;
    findResume(): Promise<{
        id: number;
        nome_empresa: string;
        documento: string;
        nome_cliente: string;
        sinc_code: string;
        email: string;
        celular: string;
        total_equipamentos: number;
        alertas_portas: number;
        status: boolean;
        role: Roles;
    }[]>;
    countAll(): Promise<number>;
    findMyProfile(id: string): Promise<{
        id: number;
        document: string;
        company_name: string;
        user_name: string;
        email: string;
        roles: Roles;
        cellphone: string;
        maintanance_notf: boolean;
        alert_notf: boolean;
        sinc_code: string;
    }>;
    findOne(id: string): Promise<import("./entities/user.entity").User | null>;
    updateUserStatus(id: string, aproved: boolean): Promise<string>;
    resetPassword(resetPasswordDto: ResetPasswordDto): Promise<{
        message: string;
    }>;
    changeUserPassword(id: string, updateUserPasswordDto: UpdateUserPasswordDto): Promise<string>;
    update(id: string, updateUserDto: UpdateUserDto): Promise<string>;
    remove(id: string): Promise<{
        message: string;
    }>;
}
