"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContactsController = void 0;
const common_2 = require("@nestjs/common");
const contacts_service_1 = require("./contacts.service");
const auth_guard_1 = require("../../shared/auth/auth.guard");
const permissions_guards_1 = require("../../shared/auth/permissions.guards");
const swagger_2 = require("@nestjs/swagger");
let ContactsController = class ContactsController {
    contactsService;
    constructor(contactsService) {
        this.contactsService = contactsService;
    }
    create(id, createContactDto) {
        return this.contactsService.create(+id, createContactDto);
    }
    findAllByUser(req) {
        return this.contactsService.findAllByUser(req.user.id);
    }
    findByUser(id) {
        return this.contactsService.findAllByUser(+id);
    }
};
exports.ContactsController = ContactsController;
__decorate([
    (0, common_2.Post)('/registro/:id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Object]),
    __metadata("design:returntype", void 0)
], ContactsController.prototype, "create", null);
__decorate([
    (0, common_2.Get)('/'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], ContactsController.prototype, "findAllByUser", null);
__decorate([
    (0, common_2.Get)('/:id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ContactsController.prototype, "findByUser", null);
exports.ContactsController = ContactsController = __decorate([
    (0, swagger_2.ApiTags)('Contatos dos avisos/alertas'),
    (0, common_2.Controller)('contatos'),
    __metadata("design:paramtypes", [contacts_service_1.ContactsService])
], ContactsController);
//# sourceMappingURL=contacts.controller.js.map