import { Repository } from 'typeorm';
import { Group } from './entities/group.entity';
import { CreateGroupDto } from './dto/create-group.dto';
import { UpdateGroupDto } from './dto/update-group.dto';
export declare class GroupService {
    private groupRepository;
    constructor(groupRepository: Repository<Group>);
    create(createGroupDto: CreateGroupDto, currentUserId: number): Promise<{
        message: string;
    }>;
    findAllByUser(currentUserId: number): Promise<Group[] | {
        message: string;
    }>;
    findOne(id: number, currentUserId: number): Promise<Group>;
    update(id: number, updateGroupDto: UpdateGroupDto, userId: number): Promise<{
        message: string;
    }>;
    remove(id: number, userId: number): Promise<{
        message: string;
    }>;
}
