"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelsService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const model_entity_1 = require("./entities/model.entity");
const typeorm_2 = require("typeorm");
let ModelsService = class ModelsService {
    modelRepository;
    constructor(modelRepository) {
        this.modelRepository = modelRepository;
    }
    async create(createModelDto) {
        let model = await this.modelRepository.findOne({
            where: {
                model_name: createModelDto.model_name
            }
        });
        if (!model) {
            const model = this.modelRepository.create(createModelDto);
            return this.modelRepository.save(model);
        }
        return "Esse modelo já existe";
    }
    findAll() {
        return this.modelRepository.find();
    }
    findOne(id) {
        return this.modelRepository.findOneBy({ id });
    }
    async update(id, updateModelDto) {
        const model = await this.modelRepository.findOneBy({ id });
        if (!model) {
            throw new common_2.NotFoundException("Modelo não encontrado");
        }
        this.modelRepository.merge(model, updateModelDto);
        return this.modelRepository.save(model);
    }
    async remove(id) {
        const model = await this.modelRepository.findOneBy({ id });
        if (!model) {
            throw new Error("Modelo não encontrado");
        }
        return this.modelRepository.remove(model);
    }
};
exports.ModelsService = ModelsService;
exports.ModelsService = ModelsService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(model_entity_1.Model)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], ModelsService);
//# sourceMappingURL=models.service.js.map