import {
  WebSocketGateway,
  WebSocketServer,
  SubscribeMessage,
  ConnectedSocket,
  MessageBody,
} from '@nestjs/websockets';
import { Server, Socket } from 'socket.io';

@WebSocketGateway({
  cors: {
    origin: '*',
  },
})
export class AsaasGateway {
  @WebSocketServer()
  server: Server;

  @SubscribeMessage('notificacao-pagamento')
  handleRoomJoin(
    @ConnectedSocket() client: Socket,
    @MessageBody()
    data: {
      customerId: string;
    },
  ) {
    client.join(data.customerId);
    console.log(`Socket ${client.id} entrou na sala do cliente: ${data.customerId}`);
    client.emit('room_joined', { rooms: [data.customerId].filter(Boolean) });
  }

  async sendConfirmedPayment(
    paymentId: string,
    customerId: string,
    status: string,
  ) {
    const sockets = await this.server.in(customerId).fetchSockets();
    if (sockets.length === 0) {
      console.warn(`Nenhum socket conectado à sala ${customerId}`);
    } else {
      console.log(`Emitindo para sala do cliente ${customerId}:`, sockets.map(s => s.id));
      this.server.to(customerId).emit('pagamento_confirmado', {
        success: true
      });
    }
  }

  async notifyStoreNewOrder(storeId: string) {
    const sockets = await this.server.in(storeId).fetchSockets();
    if (sockets.length === 0) {
      console.warn(`Nenhum socket conectado à sala da loja ${storeId}`);
    } else {
      console.log(`Notificando loja ${storeId} com sockets:`, sockets.map(s => s.id));
      this.server.to(storeId).emit('pagamento_confirmado', {
        success: true
      });
    }
  }
}
