import { IsEmail, IsInt, IsNotEmptyObject,IsNumber, IsObject, IsPositive, IsString, ValidateNested } from 'class-validator';
import { Type } from 'class-transformer';
import { User } from 'src/shared/users/entities/user.entity';
import { Creditcard } from 'src/ecommerce/creditcard/entities/creditcard.entity';

class ChargeCustomerDto {
  @IsInt()
  @IsPositive()
  id: number;

  @IsString()
  name: string;
  
  @IsEmail()
  email: string;

  @IsString()
  document: string; 

  @IsString()
  cellphone: string;
}

export class CreateChargeDto {
  @IsObject()
  @IsNotEmptyObject()
  // @ValidateNested() // Descomente se quiser validar os campos internos do usuário
  // @Type(() => ChargeCustomerDto)
  user: User;

  @IsNumber({ maxDecimalPlaces: 2 }, { message: 'O valor deve ser um número com no máximo duas casas decimais.' })
  @IsPositive({ message: 'O valor da cobrança deve ser positivo.' })
  value: number;

  @IsInt()
  @IsPositive()
  orderId: number;
}

export class CreateCreditChargeDto{
  @IsObject()
  @IsNotEmptyObject()
  user: User;

  @IsObject()
  @IsNotEmptyObject()
  creditCard: Creditcard;


  @IsNumber({ maxDecimalPlaces: 2 }, { message: 'O valor deve ser um número com no máximo duas casas decimais.' })
  @IsPositive({ message: 'O valor da cobrança deve ser positivo.' })
  value: number;

  @IsInt()
  @IsPositive()
  orderId: number;
}