import { Injectable } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { Course_payment } from "./entities/course_payment.entity";
import { CreateCourse_paymentDto } from './dto/create-course_payment.dto';
import { AsaasService } from '../asaas/asaas.service';
import { UsersService } from 'src/shared/users/users.service';
import { CourseService } from '../courses/courses.service';
import { Creditcard } from '../creditcard/entities/creditcard.entity';

@Injectable()
export class Course_paymentService {
    constructor(
    @InjectRepository(Course_payment)
    private course_paymentRepository: Repository<Course_payment>,
    @InjectRepository(Creditcard)
    private creditcardRepository: Repository<Creditcard>,
    private readonly asaasService: AsaasService,
    private readonly usersService: UsersService,
    private readonly courseService: CourseService,
    ) {}

    async create(currentUserId: number, id: number, createChargeDto: CreateCourse_paymentDto) {

        const user = await this.usersService.findUserById(currentUserId);

        const course = await this.courseService.findCourseById(id);

        if (course.price == 0) {
          const courseFree = await this.course_paymentRepository.create({
            user: { id: user.id }, 
            course: { id: course.id }, 
            amount: course.price,
            status: 'PAID'
          });

           const savedPayment = await this.course_paymentRepository.save(courseFree);

          return { success: true, message: `Curso adquirido com sucesso`, code: 200 }
        }

        
        
        // 1. Cria o registro de pagamento primeiro para obter o ID
        const course_payment = this.course_paymentRepository.create({ 
            user: { id: user.id }, 
            course: { id: course.id }, 
            amount: course.price,
            status: 'PENDING'
        });
        const savedPayment = await this.course_paymentRepository.save(course_payment);

        if(createChargeDto.paymentMethod == 'CREDIT_CARD'){

          const existCard = await this.creditcardRepository.findOne({
            where: { user: { id: currentUserId },
                    credit_card_number: createChargeDto.numeroCartao},
          });

          if(!existCard){
            throw new Error("Cartão de crédito não encontrado");
          }


          const assasPayment = await this.asaasService.createCreditCardPaymentCourse({user: user, value: course.price, orderId: savedPayment.id, creditCard: existCard})
          savedPayment.asaasPaymentId = assasPayment.paymentId;
          await this.course_paymentRepository.save(savedPayment);
          
          
          return assasPayment;
        }

        // 2. Cria a cobrança no Asaas usando o ID do pagamento como externalReference
        const assasPayment = await this.asaasService.createPixChargeForCourse({user: user, value: course.price, orderId: savedPayment.id});

        // 3. Atualiza o registro de pagamento com o ID do Asaas
        savedPayment.asaasPaymentId = assasPayment.paymentId;
        await this.course_paymentRepository.save(savedPayment);

        return assasPayment;
      }

      async getQrCode(currentUserId: number) {
        const userPayment = await this.course_paymentRepository.findOne({
            where: { 
              user: { id: currentUserId },
              status: 'PENDING'
            },
            order: { created_at: 'DESC' }
        });

        if (!userPayment) return { message: "Nenhum pagamento pendente encontrado." };

        return await this.asaasService.getPixQrCode(userPayment.asaasPaymentId);
      }

      async confirmPayment(paymentId: string) {
        const payment = await this.course_paymentRepository.findOne({
          where: { asaasPaymentId: paymentId,
            status: 'PAID'
           },
        });
        if (payment){
          return {pago: true}
        }
        return {pago: false}
      }

    
      
}